/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.mvel.ConversionException;
import org.protempa.proposition.value.AbsoluteTimeUnit;
import org.protempa.proposition.value.RelativeDayUnit;
import org.protempa.proposition.value.RelativeHourUnit;
import org.protempa.proposition.value.Unit;

class UnitValueConverter
implements SingleValueConverter {
    private static final DualHashBidiMap<Unit, String> unitToStringMap = new DualHashBidiMap();

    UnitValueConverter() {
    }

    public boolean canConvert(Class type) {
        return Unit.class.isAssignableFrom(type);
    }

    public String toString(Object obj) {
        String unitString = (String)unitToStringMap.get(obj);
        if (unitString == null) {
            String msg = "Unable to convert unexpected Unit object to an unit attribute value: " + obj.toString();
            throw new ConversionException(msg);
        }
        return unitString;
    }

    public Object fromString(String str) {
        Unit unit = (Unit)unitToStringMap.getKey((Object)str);
        if (unit == null) {
            String msg = "Unknown unit value string: " + str;
            throw new ConversionException(msg);
        }
        return unit;
    }

    static {
        unitToStringMap.put((Object)AbsoluteTimeUnit.SECOND, (Object)"absoluteSecond");
        unitToStringMap.put((Object)AbsoluteTimeUnit.MINUTE, (Object)"absoluteMinute");
        unitToStringMap.put((Object)AbsoluteTimeUnit.HOUR, (Object)"absoluteHour");
        unitToStringMap.put((Object)AbsoluteTimeUnit.DAY, (Object)"absoluteDay");
        unitToStringMap.put((Object)AbsoluteTimeUnit.WEEK, (Object)"absoluteWeek");
        unitToStringMap.put((Object)AbsoluteTimeUnit.MONTH, (Object)"absoluteMonth");
        unitToStringMap.put((Object)AbsoluteTimeUnit.YEAR, (Object)"absoluteYear");
        unitToStringMap.put((Object)RelativeDayUnit.DAY, (Object)"relativeDay");
        unitToStringMap.put((Object)RelativeHourUnit.HOUR, (Object)"relativeHour");
    }
}

