/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arp.javautil.arrays.Arrays;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.rule.Declaration;
import org.drools.spi.EvalExpression;
import org.drools.spi.Tuple;
import org.protempa.ExtendedPropositionDefinition;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.HighLevelAbstractionFinder;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.interval.Relation;

class HighLevelAbstractionCondition
implements EvalExpression {
    private static final long serialVersionUID = -4946151589366639279L;
    private final HighLevelAbstractionDefinition def;
    private final ExtendedPropositionDefinition[] epds;
    private int parameterMapCapacity;
    private List<List<TemporalExtendedPropositionDefinition>> epdPairs;
    private Map<List<TemporalExtendedPropositionDefinition>, Relation> epdToRelation;

    HighLevelAbstractionCondition(HighLevelAbstractionDefinition def, ExtendedPropositionDefinition[] epds) {
        this.def = def;
        this.epds = epds;
        this.parameterMapCapacity = this.epds.length * 4 / 3 + 1;
        this.epdPairs = new ArrayList<List<TemporalExtendedPropositionDefinition>>(def.getTemporalExtendedPropositionDefinitionPairs());
        this.epdToRelation = new HashMap<List<TemporalExtendedPropositionDefinition>, Relation>(this.parameterMapCapacity);
        for (List<TemporalExtendedPropositionDefinition> pair : this.epdPairs) {
            this.epdToRelation.put(pair, this.def.getRelation(pair));
        }
    }

    public boolean evaluate(Tuple arg0, Declaration[] arg1, WorkingMemory arg2, Object context) throws Exception {
        HashMap<TemporalExtendedPropositionDefinition, TemporalProposition> propositionMap = new HashMap<TemporalExtendedPropositionDefinition, TemporalProposition>(this.parameterMapCapacity);
        Object[] ps = new Proposition[this.epds.length];
        for (int i = 0; i < this.epds.length; ++i) {
            Proposition p = (Proposition)arg2.getObject((FactHandle)arg0.get(i));
            if (Arrays.contains((Object[])ps, (Object)p)) {
                return false;
            }
            ps[i] = p;
            if (!(this.epds[i] instanceof TemporalExtendedPropositionDefinition)) continue;
            propositionMap.put((TemporalExtendedPropositionDefinition)this.epds[i], (TemporalProposition)p);
        }
        return HighLevelAbstractionFinder.find(this.epdToRelation, this.epdPairs, propositionMap);
    }

    public Object createContext() {
        return null;
    }
}

