/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.stats;

import org.arp.javautil.stat.Line;
import org.arp.javautil.stat.UpdatingCovarCalc;
import org.arp.javautil.stat.UpdatingVarCalc;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Segment;
import org.protempa.proposition.value.NumericalValue;

public class RegressionLine
extends Line {
    private UpdatingVarCalc varCalcX = null;
    private UpdatingVarCalc varCalcY = null;
    private UpdatingCovarCalc covarCalc = null;

    public RegressionLine(Segment<PrimitiveParameter> points) throws NullValueException {
        double sumY = 0.0;
        double sumX = 0.0;
        PrimitiveParameter curPoint = points.first();
        sumX = curPoint.getPosition().longValue();
        if (curPoint.getValue() == null) {
            throw new NullValueException(curPoint);
        }
        sumY = ((NumericalValue)curPoint.getValue()).doubleValue();
        this.varCalcX = new UpdatingVarCalc(sumX);
        this.varCalcY = new UpdatingVarCalc(sumY);
        this.covarCalc = new UpdatingCovarCalc(sumX, sumY);
        int n = points.size();
        for (int i = 1; i < n; ++i) {
            curPoint = (PrimitiveParameter)points.get(i);
            double x = curPoint.getPosition().longValue();
            sumX += x;
            if (curPoint.getValue() == null) {
                throw new NullValueException(curPoint);
            }
            double y = ((NumericalValue)curPoint.getValue()).doubleValue();
            sumY += y;
            this.varCalcX.addValue(x);
            this.varCalcY.addValue(y);
            this.covarCalc.addPoint(x, y);
        }
        this.setm(this.covarCalc.getSumSquaredDeviations() / this.varCalcX.getSumSquaredDeviations());
        this.setb((sumY - this.m * sumX) / (double)points.size());
    }

    public double getRMSError() {
        double r = this.covarCalc.getSumSquaredDeviations() / Math.sqrt(this.varCalcX.getSumSquaredDeviations() * this.varCalcY.getSumSquaredDeviations());
        return Math.sqrt(1.0 - r) * this.varCalcX.getStdDev();
    }

    public static class NullValueException
    extends Exception {
        private static final long serialVersionUID = -4392403268217798814L;
        private PrimitiveParameter point;

        NullValueException(PrimitiveParameter point) {
            this.point = point;
        }

        public PrimitiveParameter getPoint() {
            return this.point;
        }
    }
}

