/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.Format;
import org.arp.javautil.string.StringUtil;
import org.protempa.dest.table.AbstractTabularWriter;
import org.protempa.dest.table.TabularWriterException;
import org.protempa.proposition.Parameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.Value;

public class FileTabularWriter
extends AbstractTabularWriter {
    private final BufferedWriter writer;
    private int colIndex;
    private final char delimiter;

    public FileTabularWriter(BufferedWriter inWriter, char inDelimiter) {
        this.writer = inWriter;
        this.delimiter = inDelimiter;
    }

    @Override
    public void writeString(String inValue) throws TabularWriterException {
        try {
            this.writeDelimiter();
            StringUtil.escapeAndWriteDelimitedColumn((String)inValue, (char)this.delimiter, (Writer)this.writer);
            this.incr();
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    @Override
    public void writeNominal(NominalValue inValue, Format inFormat) throws TabularWriterException {
        try {
            this.writeDelimiter();
            StringUtil.escapeAndWriteDelimitedColumn((String)inValue.format(inFormat), (char)this.delimiter, (Writer)this.writer);
            this.incr();
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    @Override
    public void writeNumber(NumberValue inValue, Format inFormat) throws TabularWriterException {
        try {
            this.writeDelimiter();
            StringUtil.escapeAndWriteDelimitedColumn((String)inValue.format(inFormat), (char)this.delimiter, (Writer)this.writer);
            this.incr();
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    @Override
    public void writeInequality(InequalityNumberValue inValue, Format inFormat) throws TabularWriterException {
        try {
            this.writeDelimiter();
            String comparatorString = inValue.getInequality().getComparatorString();
            StringUtil.escapeAndWriteDelimitedColumn((String)(inFormat != null ? inFormat.format(comparatorString) : comparatorString), (char)this.delimiter, (Writer)this.writer);
            this.incr();
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    @Override
    public void writeNumber(InequalityNumberValue inValue, Format inFormat) throws TabularWriterException {
        try {
            this.writeDelimiter();
            StringUtil.escapeAndWriteDelimitedColumn((String)inValue.getNumberValue().format(inFormat), (char)this.delimiter, (Writer)this.writer);
            this.incr();
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    @Override
    public void writeDate(DateValue inValue, Format inFormat) throws TabularWriterException {
        try {
            this.writeDelimiter();
            StringUtil.escapeAndWriteDelimitedColumn((String)inValue.format(inFormat), (char)this.delimiter, (Writer)this.writer);
            this.incr();
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    @Override
    public void writeBoolean(BooleanValue inValue, Format inFormat) throws TabularWriterException {
        try {
            this.writeDelimiter();
            StringUtil.escapeAndWriteDelimitedColumn((String)inValue.format(inFormat), (char)this.delimiter, (Writer)this.writer);
            this.incr();
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    @Override
    public void writeId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getId();
        this.writeString(value);
    }

    @Override
    public void writeUniqueId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getUniqueId().getStringRepresentation();
        this.writeString(value);
    }

    @Override
    public void writeStart(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inProposition.getStartFormattedShort();
        this.writeString(value);
    }

    @Override
    public void writeFinish(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inProposition.getFinishFormattedShort();
        this.writeString(value);
    }

    @Override
    public void writeLength(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inFormat != null ? inFormat.format(inProposition.getInterval().getMinLength()) : inProposition.getLengthFormattedShort();
        this.writeString(value);
    }

    @Override
    public void writeValue(Parameter inProposition, Format inFormat) throws TabularWriterException {
        Value value = inProposition.getValue();
        this.write(value, inFormat);
    }

    @Override
    public void writePropertyValue(Proposition inProposition, String inPropertyName, Format inFormat) throws TabularWriterException {
        Value value = inProposition.getProperty(inPropertyName);
        this.write(value, inFormat);
    }

    @Override
    public void writeNull() throws TabularWriterException {
        this.writeString(null);
    }

    @Override
    public void newRow() throws TabularWriterException {
        try {
            this.writer.newLine();
            this.colIndex = 0;
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    @Override
    public void close() throws TabularWriterException {
        try {
            this.writer.close();
        }
        catch (IOException ex) {
            throw new TabularWriterException(ex);
        }
    }

    private void writeDelimiter() throws IOException {
        if (this.colIndex > 0) {
            this.writer.write(this.delimiter);
        }
    }

    private void incr() {
        ++this.colIndex;
    }
}

