/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.text.DateFormat;
import java.text.Format;
import java.util.HashMap;
import java.util.Map;

public final class OutputConfig {
    private final boolean showValue;
    private final boolean showDisplayName;
    private final boolean showAbbrevDisplayName;
    private final boolean showStartOrTimestamp;
    private final boolean showFinish;
    private final boolean showLength;
    private final boolean showId;
    private final boolean showUniqueId;
    private final boolean showLocalUniqueId;
    private final boolean showNumericalId;
    private final String valueHeading;
    private final String displayNameHeading;
    private final String abbrevDisplayNameHeading;
    private final String startOrTimestampHeading;
    private final String finishHeading;
    private final String lengthHeading;
    private final String idHeading;
    private final String uniqueIdHeading;
    private final String localUniqueIdHeading;
    private final String numericalIdHeading;
    private final HashMap<String, String> propertyHeadings;
    private final Format positionFormat;

    public OutputConfig() {
        this.showValue = false;
        this.showDisplayName = false;
        this.showAbbrevDisplayName = false;
        this.showStartOrTimestamp = false;
        this.showFinish = false;
        this.showLength = false;
        this.showId = false;
        this.showUniqueId = false;
        this.showLocalUniqueId = false;
        this.showNumericalId = false;
        this.valueHeading = "";
        this.displayNameHeading = "";
        this.abbrevDisplayNameHeading = "";
        this.startOrTimestampHeading = "";
        this.finishHeading = "";
        this.lengthHeading = "";
        this.idHeading = "";
        this.uniqueIdHeading = "";
        this.localUniqueIdHeading = "";
        this.numericalIdHeading = "";
        this.propertyHeadings = new HashMap();
        this.positionFormat = null;
    }

    @Deprecated
    public OutputConfig(boolean showId, boolean showValue, boolean showDisplayName, boolean showAbbrevDisplayName, boolean showStartOrTimestamp, boolean showFinish, boolean showLength, boolean showUniqueId, String idHeading, String valueHeading, String displayNameHeading, String abbrevDisplayNameHeading, String startOrTimestampHeading, String finishHeading, String lengthHeading, String uniqueIdHeading, Map<String, String> propertyHeadings, Format positionFormat) {
        this(showId, showValue, showDisplayName, showAbbrevDisplayName, showStartOrTimestamp, showFinish, showLength, showUniqueId, false, idHeading, valueHeading, displayNameHeading, abbrevDisplayNameHeading, startOrTimestampHeading, finishHeading, lengthHeading, uniqueIdHeading, null, propertyHeadings, positionFormat);
    }

    @Deprecated
    public OutputConfig(boolean showId, boolean showValue, boolean showDisplayName, boolean showAbbrevDisplayName, boolean showStartOrTimestamp, boolean showFinish, boolean showLength, boolean showUniqueId, boolean showLocalUniqueId, String idHeading, String valueHeading, String displayNameHeading, String abbrevDisplayNameHeading, String startOrTimestampHeading, String finishHeading, String lengthHeading, String uniqueIdHeading, String localUniqueIdHeading, Map<String, String> propertyHeadings, Format positionFormat) {
        this(showId, showValue, showDisplayName, showAbbrevDisplayName, showStartOrTimestamp, showFinish, showLength, showUniqueId, false, false, idHeading, valueHeading, displayNameHeading, abbrevDisplayNameHeading, startOrTimestampHeading, finishHeading, lengthHeading, uniqueIdHeading, null, null, propertyHeadings, positionFormat);
    }

    public OutputConfig(boolean showId, boolean showValue, boolean showDisplayName, boolean showAbbrevDisplayName, boolean showStartOrTimestamp, boolean showFinish, boolean showLength, boolean showUniqueId, boolean showLocalUniqueId, boolean showNumericalId, String idHeading, String valueHeading, String displayNameHeading, String abbrevDisplayNameHeading, String startOrTimestampHeading, String finishHeading, String lengthHeading, String uniqueIdHeading, String localUniqueIdHeading, String numericalIdHeading, Map<String, String> propertyHeadings, Format positionFormat) {
        this.showId = showId;
        this.showUniqueId = showUniqueId;
        this.showLocalUniqueId = showLocalUniqueId;
        this.showNumericalId = showNumericalId;
        this.showValue = showValue;
        this.showDisplayName = showDisplayName;
        this.showAbbrevDisplayName = showAbbrevDisplayName;
        this.showStartOrTimestamp = showStartOrTimestamp;
        this.showFinish = showFinish;
        this.showLength = showLength;
        if (idHeading == null) {
            idHeading = "";
        }
        this.idHeading = idHeading;
        if (valueHeading == null) {
            valueHeading = "";
        }
        this.valueHeading = valueHeading;
        if (displayNameHeading == null) {
            displayNameHeading = "";
        }
        this.displayNameHeading = displayNameHeading;
        if (abbrevDisplayNameHeading == null) {
            abbrevDisplayNameHeading = "";
        }
        this.abbrevDisplayNameHeading = abbrevDisplayNameHeading;
        if (startOrTimestampHeading == null) {
            startOrTimestampHeading = "";
        }
        this.startOrTimestampHeading = startOrTimestampHeading;
        if (finishHeading == null) {
            finishHeading = "";
        }
        this.finishHeading = finishHeading;
        if (lengthHeading == null) {
            lengthHeading = "";
        }
        this.lengthHeading = lengthHeading;
        if (uniqueIdHeading == null) {
            uniqueIdHeading = "";
        }
        this.uniqueIdHeading = uniqueIdHeading;
        if (localUniqueIdHeading == null) {
            localUniqueIdHeading = "";
        }
        this.localUniqueIdHeading = localUniqueIdHeading;
        if (numericalIdHeading == null) {
            numericalIdHeading = "";
        }
        this.numericalIdHeading = numericalIdHeading;
        this.propertyHeadings = propertyHeadings != null ? new HashMap<String, String>(propertyHeadings) : new HashMap();
        this.positionFormat = positionFormat;
    }

    public String getIdHeading() {
        return this.idHeading;
    }

    public String getUniqueIdHeading() {
        return this.uniqueIdHeading;
    }

    public String getLocalUniqueIdHeading() {
        return this.localUniqueIdHeading;
    }

    public String getNumericalIdHeading() {
        return this.numericalIdHeading;
    }

    public String getValueHeading() {
        return this.valueHeading;
    }

    public String getDisplayNameHeading() {
        return this.displayNameHeading;
    }

    public String getAbbrevDisplayNameHeading() {
        return this.abbrevDisplayNameHeading;
    }

    public String getStartOrTimestampHeading() {
        return this.startOrTimestampHeading;
    }

    public String getFinishHeading() {
        return this.finishHeading;
    }

    public String getLengthHeading() {
        return this.lengthHeading;
    }

    public Format getPositionFormat() {
        return this.positionFormat;
    }

    public boolean showId() {
        return this.showId;
    }

    public boolean showUniqueId() {
        return this.showUniqueId;
    }

    public boolean showLocalUniqueId() {
        return this.showLocalUniqueId;
    }

    public boolean showNumericalId() {
        return this.showNumericalId;
    }

    public boolean showValue() {
        return this.showValue;
    }

    public boolean showDisplayName() {
        return this.showDisplayName;
    }

    public boolean showAbbrevDisplayName() {
        return this.showAbbrevDisplayName;
    }

    public boolean showStartOrTimestamp() {
        return this.showStartOrTimestamp;
    }

    public boolean showFinish() {
        return this.showFinish;
    }

    public boolean showLength() {
        return this.showLength;
    }

    public Map<String, String> getPropertyHeadings() {
        return new HashMap<String, String>(this.propertyHeadings);
    }

    public String getPropertyHeading(String propertyName) {
        return this.propertyHeadings.get(propertyName);
    }

    public int getNumberOfColumns() {
        int i = 0;
        if (this.showId) {
            ++i;
        }
        if (this.showUniqueId) {
            ++i;
        }
        if (this.showLocalUniqueId) {
            ++i;
        }
        if (this.showNumericalId) {
            ++i;
        }
        if (this.showAbbrevDisplayName) {
            ++i;
        }
        if (this.showDisplayName) {
            ++i;
        }
        if (this.showFinish) {
            ++i;
        }
        if (this.showLength) {
            ++i;
        }
        if (this.showStartOrTimestamp) {
            ++i;
        }
        if (this.showValue) {
            ++i;
        }
        return i += this.propertyHeadings.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abbrevDisplayNameHeading == null ? 0 : this.abbrevDisplayNameHeading.hashCode());
        result = 31 * result + (this.displayNameHeading == null ? 0 : this.displayNameHeading.hashCode());
        result = 31 * result + (this.finishHeading == null ? 0 : this.finishHeading.hashCode());
        result = 31 * result + (this.idHeading == null ? 0 : this.idHeading.hashCode());
        result = 31 * result + (this.uniqueIdHeading == null ? 0 : this.uniqueIdHeading.hashCode());
        result = 31 * result + (this.localUniqueIdHeading == null ? 0 : this.localUniqueIdHeading.hashCode());
        result = 31 * result + (this.numericalIdHeading == null ? 0 : this.numericalIdHeading.hashCode());
        result = 31 * result + (this.lengthHeading == null ? 0 : this.lengthHeading.hashCode());
        result = 31 * result + (this.showAbbrevDisplayName ? 1231 : 1237);
        result = 31 * result + (this.showDisplayName ? 1231 : 1237);
        result = 31 * result + (this.showFinish ? 1231 : 1237);
        result = 31 * result + (this.showId ? 1231 : 1237);
        result = 31 * result + (this.showUniqueId ? 1231 : 1237);
        result = 31 * result + (this.showLocalUniqueId ? 1231 : 1237);
        result = 31 * result + (this.showNumericalId ? 1231 : 1237);
        result = 31 * result + (this.showLength ? 1231 : 1237);
        result = 31 * result + (this.showStartOrTimestamp ? 1231 : 1237);
        result = 31 * result + (this.showValue ? 1231 : 1237);
        result = 31 * result + (this.startOrTimestampHeading == null ? 0 : this.startOrTimestampHeading.hashCode());
        result = 31 * result + (this.valueHeading == null ? 0 : this.valueHeading.hashCode());
        result = 31 * result + this.propertyHeadings.hashCode();
        result = 31 * result + (this.positionFormat == null ? 0 : this.positionFormat.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OutputConfig other = (OutputConfig)obj;
        if (this.abbrevDisplayNameHeading == null ? other.abbrevDisplayNameHeading != null : !this.abbrevDisplayNameHeading.equals(other.abbrevDisplayNameHeading)) {
            return false;
        }
        if (this.displayNameHeading == null ? other.displayNameHeading != null : !this.displayNameHeading.equals(other.displayNameHeading)) {
            return false;
        }
        if (this.finishHeading == null ? other.finishHeading != null : !this.finishHeading.equals(other.finishHeading)) {
            return false;
        }
        if (this.idHeading == null ? other.idHeading != null : !this.idHeading.equals(other.idHeading)) {
            return false;
        }
        if (this.uniqueIdHeading == null ? other.uniqueIdHeading != null : !this.uniqueIdHeading.equals(other.uniqueIdHeading)) {
            return false;
        }
        if (this.localUniqueIdHeading == null ? other.localUniqueIdHeading != null : !this.localUniqueIdHeading.equals(other.localUniqueIdHeading)) {
            return false;
        }
        if (this.numericalIdHeading == null ? other.numericalIdHeading != null : !this.numericalIdHeading.equals(other.numericalIdHeading)) {
            return false;
        }
        if (this.lengthHeading == null ? other.lengthHeading != null : !this.lengthHeading.equals(other.lengthHeading)) {
            return false;
        }
        if (this.showAbbrevDisplayName != other.showAbbrevDisplayName) {
            return false;
        }
        if (this.showDisplayName != other.showDisplayName) {
            return false;
        }
        if (this.showFinish != other.showFinish) {
            return false;
        }
        if (this.showId != other.showId) {
            return false;
        }
        if (this.showUniqueId != other.showUniqueId) {
            return false;
        }
        if (this.showLocalUniqueId != other.showLocalUniqueId) {
            return false;
        }
        if (this.showNumericalId != other.showNumericalId) {
            return false;
        }
        if (this.showLength != other.showLength) {
            return false;
        }
        if (this.showStartOrTimestamp != other.showStartOrTimestamp) {
            return false;
        }
        if (this.showValue != other.showValue) {
            return false;
        }
        if (this.startOrTimestampHeading == null ? other.startOrTimestampHeading != null : !this.startOrTimestampHeading.equals(other.startOrTimestampHeading)) {
            return false;
        }
        if (this.valueHeading == null ? other.valueHeading != null : !this.valueHeading.equals(other.valueHeading)) {
            return false;
        }
        if (!this.propertyHeadings.equals(other.propertyHeadings)) {
            return false;
        }
        return !(this.positionFormat == null ? other.positionFormat != null : !this.positionFormat.equals(other.positionFormat));
    }

    public static final class Builder {
        private boolean showValue;
        private boolean showDisplayName;
        private boolean showAbbrevDisplayName;
        private boolean showStartOrTimestamp;
        private boolean showFinish;
        private boolean showLength;
        private boolean showId;
        private boolean showUniqueId;
        private boolean showLocalUniqueId;
        private boolean showNumericalId;
        private String valueHeading;
        private String displayNameHeading;
        private String abbrevDisplayNameHeading;
        private String startOrTimestampHeading;
        private String finishHeading;
        private String lengthHeading;
        private String idHeading;
        private String uniqueIdHeading;
        private String localUniqueIdHeading;
        private String numericalIdHeading;
        private Map<String, String> propertyHeadings;
        private DateFormat dateFormat;

        public Builder() {
            this.reset();
        }

        public void reset() {
            this.valueHeading = "";
            this.displayNameHeading = "";
            this.abbrevDisplayNameHeading = "";
            this.startOrTimestampHeading = "";
            this.finishHeading = "";
            this.lengthHeading = "";
            this.idHeading = "";
            this.uniqueIdHeading = "";
            this.localUniqueIdHeading = "";
            this.numericalIdHeading = "";
            this.showValue = false;
            this.showDisplayName = false;
            this.showAbbrevDisplayName = false;
            this.showStartOrTimestamp = false;
            this.showFinish = false;
            this.showLength = false;
            this.showId = false;
            this.showUniqueId = false;
            this.showLocalUniqueId = false;
            this.showNumericalId = false;
            this.propertyHeadings = new HashMap<String, String>();
            this.dateFormat = null;
        }

        public String getIdHeading() {
            return this.idHeading;
        }

        public Builder idHeading(String idHeading) {
            if (idHeading == null) {
                idHeading = "";
            }
            this.idHeading = idHeading;
            return this;
        }

        public String getUniqueIdHeading() {
            return this.uniqueIdHeading;
        }

        public Builder uniqueIdHeading(String uniqueIdHeading) {
            this.uniqueIdHeading = uniqueIdHeading;
            return this;
        }

        public String getLocalUniqueIdHeading() {
            return this.localUniqueIdHeading;
        }

        public Builder localUniqueIdHeading(String localUniqueIdHeading) {
            this.localUniqueIdHeading = localUniqueIdHeading;
            return this;
        }

        public String getNumericalIdHeading() {
            return this.numericalIdHeading;
        }

        public Builder numericalIdHeading(String numericalIdHeading) {
            this.numericalIdHeading = numericalIdHeading;
            return this;
        }

        public String getValueHeading() {
            return this.valueHeading;
        }

        public Builder valueHeading(String valueHeading) {
            if (valueHeading == null) {
                valueHeading = "";
            }
            this.valueHeading = valueHeading;
            return this;
        }

        public String getDisplayNameHeading() {
            return this.displayNameHeading;
        }

        public Builder displayNameHeading(String displayNameHeading) {
            if (displayNameHeading == null) {
                displayNameHeading = "";
            }
            this.displayNameHeading = displayNameHeading;
            return this;
        }

        public String getAbbrevDisplayNameHeading() {
            return this.abbrevDisplayNameHeading;
        }

        public Builder abbrevDisplayNameHeading(String abbrevDisplayNameHeading) {
            if (abbrevDisplayNameHeading == null) {
                abbrevDisplayNameHeading = "";
            }
            this.abbrevDisplayNameHeading = abbrevDisplayNameHeading;
            return this;
        }

        public String getStartOrTimestampHeading() {
            return this.startOrTimestampHeading;
        }

        public Builder startOrTimestampHeading(String startOrTimestampHeading) {
            if (startOrTimestampHeading == null) {
                startOrTimestampHeading = "";
            }
            this.startOrTimestampHeading = startOrTimestampHeading;
            return this;
        }

        public String getFinishHeading() {
            return this.finishHeading;
        }

        public Builder finishHeading(String finishHeading) {
            if (finishHeading == null) {
                finishHeading = "";
            }
            this.finishHeading = finishHeading;
            return this;
        }

        public String getLengthHeading() {
            return this.lengthHeading;
        }

        public Builder lengthHeading(String lengthHeading) {
            if (lengthHeading == null) {
                lengthHeading = "";
            }
            this.lengthHeading = lengthHeading;
            return this;
        }

        public boolean getShowId() {
            return this.showId;
        }

        public Builder showId() {
            this.showId = true;
            return this;
        }

        public boolean getShowUniqueId() {
            return this.showUniqueId;
        }

        public Builder showUniqueId() {
            this.showUniqueId = true;
            return this;
        }

        public boolean getShowLocalUniqueId() {
            return this.showLocalUniqueId;
        }

        public Builder showLocalUniqueId() {
            this.showLocalUniqueId = true;
            return this;
        }

        public boolean getShowNumericalId() {
            return this.showNumericalId;
        }

        public Builder showNumericalId() {
            this.showNumericalId = true;
            return this;
        }

        public boolean getShowValue() {
            return this.showValue;
        }

        public Builder showValue() {
            this.showValue = true;
            return this;
        }

        public boolean getShowDisplayName() {
            return this.showDisplayName;
        }

        public Builder showDisplayName() {
            this.showDisplayName = true;
            return this;
        }

        public boolean getShowAbbrevDisplayName() {
            return this.showAbbrevDisplayName;
        }

        public Builder showAbbrevDisplayName() {
            this.showAbbrevDisplayName = true;
            return this;
        }

        public boolean getShowStartOrTimestamp() {
            return this.showStartOrTimestamp;
        }

        public Builder showStartOrTimestamp() {
            this.showStartOrTimestamp = true;
            return this;
        }

        public boolean getShowFinish() {
            return this.showFinish;
        }

        public Builder showFinish() {
            this.showFinish = true;
            return this;
        }

        public boolean getShowLength() {
            return this.showLength;
        }

        public Builder showLength() {
            this.showLength = true;
            return this;
        }

        public HashMap<String, String> getPropertyHeadings() {
            return new HashMap<String, String>(this.propertyHeadings);
        }

        public String getPropertyHeading(String propertyName) {
            return this.propertyHeadings.get(propertyName);
        }

        public Builder propertyHeadings(HashMap<String, String> propertyHeadings) {
            this.propertyHeadings = propertyHeadings == null ? new HashMap<String, String>() : propertyHeadings;
            return this;
        }

        public Builder putPropertyHeading(String propertyName, String propertyHeading) {
            this.propertyHeadings.put(propertyName, propertyHeading);
            return this;
        }

        public DateFormat getDateFormat() {
            return this.dateFormat;
        }

        public Builder dateFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public OutputConfig build() {
            return new OutputConfig(this.showId, this.showValue, this.showDisplayName, this.showAbbrevDisplayName, this.showStartOrTimestamp, this.showFinish, this.showLength, this.showUniqueId, this.showLocalUniqueId, this.showNumericalId, this.idHeading, this.valueHeading, this.displayNameHeading, this.abbrevDisplayNameHeading, this.startOrTimestampHeading, this.finishHeading, this.lengthHeading, this.uniqueIdHeading, this.localUniqueIdHeading, this.numericalIdHeading, this.propertyHeadings, this.dateFormat);
        }
    }
}

