/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.commons.lang3.StringUtils;
import org.drools.StatefulSession;
import org.protempa.AbstractionDefinition;
import org.protempa.AlgorithmSource;
import org.protempa.AlgorithmSourceUpdatedEvent;
import org.protempa.CloseException;
import org.protempa.ContextDefinition;
import org.protempa.DataSource;
import org.protempa.DataSourceUpdatedEvent;
import org.protempa.Executor;
import org.protempa.ExecutorStrategy;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.KnowledgeSourceUpdatedEvent;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaEventListener;
import org.protempa.ProtempaUtil;
import org.protempa.QueryException;
import org.protempa.QueryValidationException;
import org.protempa.SourceCloseException;
import org.protempa.SourceClosedUnexpectedlyEvent;
import org.protempa.SourceListener;
import org.protempa.TermSource;
import org.protempa.TermSourceUpdatedEvent;
import org.protempa.dest.Destination;
import org.protempa.query.Query;
import org.protempa.query.QueryBuildException;
import org.protempa.query.QueryBuilder;

final class AbstractionFinder {
    private final Map<String, StatefulSession> workingMemoryCache;
    private final DataSource dataSource;
    private final KnowledgeSource knowledgeSource;
    private final TermSource termSource;
    private final AlgorithmSource algorithmSource;
    private boolean closed;
    private Executor executor;
    private final List<? extends ProtempaEventListener> eventListeners;

    AbstractionFinder(DataSource dataSource, KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource, TermSource termSource, boolean cacheFoundAbstractParameters, List<? extends ProtempaEventListener> eventListeners) throws KnowledgeSourceReadException {
        assert (dataSource != null) : "dataSource cannot be null";
        assert (knowledgeSource != null) : "knowledgeSource cannot be null";
        assert (algorithmSource != null) : "algorithmSource cannot be null";
        assert (termSource != null) : "termSource cannot be null";
        assert (eventListeners != null) : "eventListeners cannot be null";
        this.dataSource = dataSource;
        this.knowledgeSource = knowledgeSource;
        this.termSource = termSource;
        this.algorithmSource = algorithmSource;
        this.eventListeners = eventListeners;
        this.dataSource.setEventListeners(eventListeners);
        this.knowledgeSource.setEventListeners(eventListeners);
        this.termSource.setEventListeners(eventListeners);
        this.algorithmSource.setEventListeners(eventListeners);
        this.dataSource.addSourceListener(new SourceListener<DataSourceUpdatedEvent>(){

            @Override
            public void sourceUpdated(DataSourceUpdatedEvent event) {
            }

            @Override
            public void closedUnexpectedly(SourceClosedUnexpectedlyEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.knowledgeSource.addSourceListener(new SourceListener<KnowledgeSourceUpdatedEvent>(){

            @Override
            public void sourceUpdated(KnowledgeSourceUpdatedEvent event) {
            }

            @Override
            public void closedUnexpectedly(SourceClosedUnexpectedlyEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.termSource.addSourceListener(new SourceListener<TermSourceUpdatedEvent>(){

            @Override
            public void sourceUpdated(TermSourceUpdatedEvent event) {
            }

            @Override
            public void closedUnexpectedly(SourceClosedUnexpectedlyEvent e) {
                throw new UnsupportedOperationException("Not supported yet");
            }
        });
        this.algorithmSource.addSourceListener(new SourceListener<AlgorithmSourceUpdatedEvent>(){

            @Override
            public void sourceUpdated(AlgorithmSourceUpdatedEvent event) {
            }

            @Override
            public void closedUnexpectedly(SourceClosedUnexpectedlyEvent e) {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        });
        this.workingMemoryCache = cacheFoundAbstractParameters ? new HashMap<String, StatefulSession>() : null;
    }

    List<? extends ProtempaEventListener> getEventListeners() {
        return this.eventListeners;
    }

    DataSource getDataSource() {
        return this.dataSource;
    }

    KnowledgeSource getKnowledgeSource() {
        return this.knowledgeSource;
    }

    AlgorithmSource getAlgorithmSource() {
        return this.algorithmSource;
    }

    TermSource getTermSource() {
        return this.termSource;
    }

    Set<String> getKnownKeys() {
        if (this.workingMemoryCache != null) {
            return Collections.unmodifiableSet(this.workingMemoryCache.keySet());
        }
        return Collections.emptySet();
    }

    void doFind(Query query, Destination destination) throws QueryException {
        ExecutorStrategy strategy;
        assert (destination != null) : "destination cannot be null";
        try {
            strategy = !this.hasSomethingToAbstract(query) ? null : (this.workingMemoryCache != null ? ExecutorStrategy.STATEFUL : ExecutorStrategy.STATELESS);
        }
        catch (QueryValidationException ex) {
            throw new QueryException(query.getName(), ex);
        }
        try {
            this.executor = new Executor(query, destination, strategy, this);
            this.executor.init();
            this.executor.execute();
            this.executor.close();
            this.executor = null;
        }
        catch (CloseException ex) {
            this.executor = null;
            throw new QueryException(query.getName(), ex);
        }
        finally {
            if (this.executor != null) {
                try {
                    this.executor.close();
                }
                catch (CloseException closeException) {}
            }
        }
    }

    void cancel() {
        if (this.executor != null) {
            this.executor.cancel();
        }
    }

    private boolean hasSomethingToAbstract(Query query) throws QueryValidationException {
        try {
            if (!this.knowledgeSource.readAbstractionDefinitions(query.getPropositionIds()).isEmpty() || !this.knowledgeSource.readContextDefinitions(query.getPropositionIds()).isEmpty()) {
                return true;
            }
            for (PropositionDefinition propDef : query.getPropositionDefinitions()) {
                if (!(propDef instanceof AbstractionDefinition) && !(propDef instanceof ContextDefinition)) continue;
                return true;
            }
            return false;
        }
        catch (KnowledgeSourceReadException ex) {
            throw new QueryValidationException("Invalid proposition id(s) " + StringUtils.join((Object[])query.getPropositionIds(), (String)", "), ex);
        }
    }

    Query buildQuery(QueryBuilder queryBuilder) throws QueryBuildException {
        return queryBuilder.build(this.knowledgeSource, this.algorithmSource);
    }

    void clear() {
        if (this.workingMemoryCache != null) {
            Iterator<StatefulSession> itr = this.workingMemoryCache.values().iterator();
            while (itr.hasNext()) {
                try {
                    itr.next().dispose();
                    itr.remove();
                }
                catch (Exception e) {
                    ProtempaUtil.logger().log(Level.SEVERE, "Could not dispose stateful rule session", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws CloseException {
        CloseException exception = null;
        this.clear();
        boolean algorithmSourceClosed = false;
        boolean knowledgeSourceClosed = false;
        boolean termSourceClosed = false;
        try {
            this.algorithmSource.close();
            algorithmSourceClosed = true;
            this.knowledgeSource.close();
            knowledgeSourceClosed = true;
            this.termSource.close();
            termSourceClosed = true;
        }
        catch (SourceCloseException e) {
            exception = new CloseException(e);
        }
        finally {
            if (!algorithmSourceClosed) {
                try {
                    this.algorithmSource.close();
                }
                catch (SourceCloseException e) {}
            }
            if (!knowledgeSourceClosed) {
                try {
                    this.knowledgeSource.close();
                }
                catch (SourceCloseException e) {}
            }
            if (!termSourceClosed) {
                try {
                    this.termSource.close();
                }
                catch (SourceCloseException e) {}
            }
        }
        try {
            this.dataSource.close();
        }
        catch (SourceCloseException ex) {
            if (exception == null) {
                exception = new CloseException(ex);
            }
            exception.addSuppressed(ex);
        }
        if (exception != null) {
            throw exception;
        }
        this.closed = true;
    }

    boolean isClosed() {
        return this.closed;
    }
}

