/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.sql.ConnectionSpec;

public abstract class RecordHandler<E>
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(RecordHandler.class.getName());
    private static final String SQL_RUNNER_BATCH_SIZE_PROPERTY = "aiw.i2b2Etl.sqlRunner.batchSize";
    private static final String SQL_RUNNER_COMMIT_SIZE_PROPERTY = "aiw.i2b2Etl.sqlRunner.commitSize";
    private final int batchSize = Integer.getInteger("aiw.i2b2Etl.sqlRunner.batchSize", 1000);
    private final int commitSize = Integer.getInteger("aiw.i2b2Etl.sqlRunner.commitSize", 10000);
    private int commitCounter;
    private int counter;
    private volatile PreparedStatement ps;
    private final String statement;
    private Connection cn;
    private final Timestamp importTimestamp;
    private final boolean commit;
    private final List<E> records;
    private final int maxTries;
    private ConnectionSpec connSpec;

    public RecordHandler(Connection connection, String statement) throws SQLException {
        this(connection, statement, true);
    }

    public RecordHandler(Connection connection, String statement, boolean commit) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("statement cannot be null");
        }
        this.cn = connection;
        this.statement = statement;
        this.importTimestamp = new Timestamp(System.currentTimeMillis());
        this.commit = commit;
        this.records = new ArrayList();
        this.maxTries = 1;
        this.counter = 0;
        this.commitCounter = 0;
        this.init();
    }

    public RecordHandler(ConnectionSpec connSpec, String statement) throws SQLException {
        if (connSpec == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        if (statement == null) {
            throw new IllegalArgumentException("statement cannot be null");
        }
        this.connSpec = connSpec;
        this.statement = statement;
        this.importTimestamp = new Timestamp(System.currentTimeMillis());
        this.commit = true;
        this.records = new ArrayList();
        this.maxTries = 3;
        this.counter = 0;
        this.commitCounter = 0;
        this.init();
    }

    public void insert(E record) throws SQLException {
        block8: {
            if (record != null) {
                try {
                    this.records.add(record);
                    ++this.counter;
                    ++this.commitCounter;
                    this.setParameters(this.ps, record);
                    this.ps.addBatch();
                    if (this.counter >= this.batchSize) {
                        this.executeBatch();
                    }
                    if (this.commitCounter >= this.commitSize) {
                        this.commit();
                    }
                }
                catch (SQLException e) {
                    this.rollback(e);
                    if (this.ps != null) {
                        try {
                            this.ps.close();
                        }
                        catch (SQLException sqle) {
                            e.addSuppressed(sqle);
                        }
                    }
                    if (this.records.isEmpty() || this.connSpec == null) break block8;
                    this.retry(e, false);
                }
            }
        }
    }

    protected abstract void setParameters(PreparedStatement var1, E var2) throws SQLException;

    protected Connection getConnection() {
        return this.cn;
    }

    @Override
    public void close() throws SQLException {
        SQLException exceptionThrown = null;
        if (this.ps != null) {
            try {
                block19: {
                    try {
                        this.executeBatch();
                        this.commit();
                    }
                    catch (SQLException ex) {
                        this.rollback(ex);
                        exceptionThrown = ex;
                        if (this.records.isEmpty() || this.connSpec == null) break block19;
                        this.retry(exceptionThrown, true);
                    }
                }
                this.ps.close();
                this.ps = null;
            }
            finally {
                if (this.ps != null) {
                    try {
                        this.ps.close();
                    }
                    catch (SQLException ignore) {
                        if (exceptionThrown != null) {
                            exceptionThrown.addSuppressed(ignore);
                        }
                        exceptionThrown = ignore;
                    }
                }
                if (this.connSpec != null && this.cn != null) {
                    try {
                        this.cn.close();
                    }
                    catch (SQLException ignore) {
                        if (exceptionThrown != null) {
                            exceptionThrown.addSuppressed(ignore);
                        }
                        exceptionThrown = ignore;
                    }
                }
            }
        }
        if (exceptionThrown != null) {
            throw exceptionThrown;
        }
    }

    protected Timestamp importTimestamp() {
        return this.importTimestamp;
    }

    private void init() throws SQLException {
        if (this.connSpec != null) {
            this.cn = this.connSpec.getOrCreate();
        }
        this.ps = this.cn.prepareStatement(this.statement);
        this.counter = 0;
        this.commitCounter = 0;
    }

    private void executeBatch() throws SQLException {
        if (this.counter > 0) {
            this.ps.executeBatch();
            this.counter = 0;
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.log(Level.FINER, "Batch executed successfully");
            }
            this.ps.clearBatch();
            this.ps.clearParameters();
        }
    }

    private void commit() throws SQLException {
        if (this.commitCounter > 0) {
            if (this.commit) {
                this.cn.commit();
            }
            this.commitCounter = 0;
            this.records.clear();
        }
    }

    private void retry(SQLException e, boolean inClose) throws SQLException {
        LOGGER.log(Level.WARNING, "Retrying after database error", e);
        int tried = 0;
        while (++tried <= this.maxTries) {
            try {
                this.reconnectAndReplay(inClose);
                break;
            }
            catch (SQLException ex) {
                LOGGER.log(Level.WARNING, "Retrying failed");
                e.addSuppressed(ex);
                if (tried != this.maxTries) continue;
                LOGGER.log(Level.SEVERE, "Giving up after " + tried + " tries", ex);
                throw e;
            }
        }
    }

    private void reconnectAndReplay(boolean inClose) throws SQLException {
        this.init();
        for (E record : this.records) {
            this.setParameters(this.ps, record);
            this.ps.addBatch();
            ++this.counter;
            ++this.commitCounter;
        }
        if (!this.records.isEmpty()) {
            try {
                if (inClose) {
                    this.executeBatch();
                    this.commit();
                } else {
                    if (this.counter >= this.batchSize) {
                        this.executeBatch();
                    }
                    if (this.commitCounter >= this.commitSize) {
                        this.commit();
                    }
                }
            }
            catch (SQLException ex) {
                this.rollback(ex);
                throw ex;
            }
        }
    }

    private void rollback(Throwable throwable) {
        if (this.commit) {
            try {
                this.cn.rollback();
            }
            catch (SQLException ignore) {
                throwable.addSuppressed(ignore);
            }
        }
    }
}

