/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.sql.SQLException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Map;
import org.arp.javautil.sql.ConnectionSpec;
import org.protempa.dest.table.AbstractTabularWriter;
import org.protempa.dest.table.ListRecordHandler;
import org.protempa.dest.table.RecordHandler;
import org.protempa.dest.table.TabularWriterException;
import org.protempa.proposition.Parameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.Value;

public class RelDbTabularWriter
extends AbstractTabularWriter {
    private final RecordHandler<ArrayList<?>> recordHandler;
    private final ArrayList<Object> row;
    private int colIndex;

    public RelDbTabularWriter(ConnectionSpec inConnectionSpec, String inStatement) throws SQLException {
        this.recordHandler = new ListRecordHandler(inConnectionSpec, inStatement);
        this.row = new ArrayList();
    }

    @Override
    public void writeString(String inValue) throws TabularWriterException {
        this.row.add(inValue);
        this.incr();
    }

    @Override
    public void writeNominal(NominalValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue.getString());
        }
        this.incr();
    }

    @Override
    public void writeNumber(NumberValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue.getNumber());
        }
        this.incr();
    }

    @Override
    public void writeInequality(InequalityNumberValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inFormat.format((Object)inValue.getComparator()));
        } else {
            this.row.add(inValue.getComparator().getComparatorString());
        }
        this.incr();
    }

    @Override
    public void writeNumber(InequalityNumberValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue.getNumber());
        }
        this.incr();
    }

    @Override
    public void writeDate(DateValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue.getDate());
        }
        this.incr();
    }

    @Override
    public void writeBoolean(BooleanValue inValue, Format inFormat) {
        if (inFormat != null) {
            this.row.add(inValue.format(inFormat));
        } else {
            this.row.add(inValue.getBoolean());
        }
        this.incr();
    }

    @Override
    public void writeId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getId();
        this.writeString(value);
    }

    @Override
    public void writeUniqueId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getUniqueId().getStringRepresentation();
        this.writeString(value);
    }

    @Override
    public void writeLocalUniqueId(Proposition inProposition) throws TabularWriterException {
        String value = inProposition.getUniqueId().getLocalUniqueId().getId();
        this.writeString(value);
    }

    @Override
    public void writeNumericalId(Proposition inProposition) throws TabularWriterException {
        String value = String.valueOf(inProposition.getUniqueId().getLocalUniqueId().getNumericalId());
        this.writeString(value);
    }

    @Override
    public void writeStart(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inProposition.getStartFormattedShort();
        this.writeString(value);
    }

    @Override
    public void writeFinish(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inProposition.getFinishFormattedShort();
        this.writeString(value);
    }

    @Override
    public void writeLength(TemporalProposition inProposition, Format inFormat) throws TabularWriterException {
        String value = inFormat != null ? inFormat.format(inProposition.getInterval().getMinLength()) : inProposition.getLengthFormattedShort();
        this.writeString(value);
    }

    @Override
    public void writeValue(Parameter inProposition, Format inFormat) throws TabularWriterException {
        Value value = inProposition.getValue();
        this.write(value, inFormat);
    }

    @Override
    public void writePropertyValue(Proposition inProposition, String inPropertyName, Format inFormat) throws TabularWriterException {
        Value value = inProposition.getProperty(inPropertyName);
        this.write(value, inFormat);
    }

    @Override
    public void writeNull() throws TabularWriterException {
        this.write(null, null);
    }

    @Override
    public void newRow() throws TabularWriterException {
        try {
            this.recordHandler.insert(this.row);
        }
        catch (SQLException ex) {
            throw new TabularWriterException(ex);
        }
        this.colIndex = 0;
    }

    @Override
    public void close() throws TabularWriterException {
        try {
            this.recordHandler.close();
        }
        catch (SQLException ex) {
            throw new TabularWriterException(ex);
        }
    }

    private int incr() {
        return this.colIndex++;
    }

    private <E> E doReplace(E val, Map<E, E> replace) {
        if (replace != null) {
            if (replace.containsKey(val)) {
                return replace.get(val);
            }
            return val;
        }
        return val;
    }
}

