/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropertyConstraint;
import org.protempa.ProtempaUtil;
import org.protempa.proposition.Proposition;

public class ExtendedPropositionDefinition
implements Serializable {
    private static final long serialVersionUID = 3835638971180620664L;
    private static final PropertyConstraint[] EMPTY_PROP_CONSTRAINT_ARR = new PropertyConstraint[0];
    private String propositionId;
    private String displayName;
    private String abbreviatedDisplayName;
    private PropertyConstraint[] propertyConstraints;
    private volatile int hashCode;

    public ExtendedPropositionDefinition(String propositionId) {
        if (propositionId == null) {
            throw new IllegalArgumentException("A propositionId must be specified");
        }
        this.propositionId = propositionId;
        this.propertyConstraints = EMPTY_PROP_CONSTRAINT_ARR;
    }

    public final String getPropositionId() {
        return this.propositionId;
    }

    public final void setPropertyConstraints(PropertyConstraint[] propertyConstraints) {
        if (propertyConstraints != null) {
            ProtempaUtil.checkArrayForNullElement(propertyConstraints, "propertyConstraints");
            this.propertyConstraints = (PropertyConstraint[])propertyConstraints.clone();
        } else {
            this.propertyConstraints = EMPTY_PROP_CONSTRAINT_ARR;
        }
    }

    public final PropertyConstraint[] getPropertyConstraints() {
        return (PropertyConstraint[])this.propertyConstraints.clone();
    }

    boolean getMatches(Proposition proposition, Collection<String> propIds) throws KnowledgeSourceReadException {
        if (proposition == null) {
            return false;
        }
        String pId = proposition.getId();
        if (this.propositionId != null && !propIds.contains(pId)) {
            return false;
        }
        for (PropertyConstraint pc : this.propertyConstraints) {
            if (pc.isSatisfiedBy(proposition)) continue;
            return false;
        }
        return true;
    }

    public final String getDisplayName() {
        return this.displayName;
    }

    public final String getAbbreviatedDisplayName() {
        return this.abbreviatedDisplayName;
    }

    public final String getShortDisplayName() {
        String abbrevDisplayName = this.getAbbreviatedDisplayName();
        if (abbrevDisplayName != null && abbrevDisplayName.length() > 0) {
            return abbrevDisplayName;
        }
        return this.getDisplayName();
    }

    public final void setAbbreviatedDisplayName(String abbreviatedDisplayName) {
        this.abbreviatedDisplayName = abbreviatedDisplayName;
    }

    public final void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = super.hashCode();
        }
        return this.hashCode;
    }

    public boolean hasEqualFields(ExtendedPropositionDefinition obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.propositionId.equals(obj.propositionId);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

