/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.cli;

import java.util.ArrayList;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.StringUtils;
import org.protempa.CloseException;
import org.protempa.Protempa;
import org.protempa.ProtempaStartupException;
import org.protempa.cli.CLIException;

public abstract class CLI {
    private Protempa protempa;
    private CommandLine commandLine;
    private final String shellCommand;
    private final Argument[] arguments;
    private final boolean configurationIdEnabled;

    protected CLI() {
        this(null, null);
    }

    protected CLI(String shellCommand) {
        this(shellCommand, null);
    }

    protected CLI(Argument[] arguments) {
        this(null, arguments, true);
    }

    protected CLI(String shellCommand, Argument[] arguments) {
        this(shellCommand, arguments, true);
    }

    protected CLI(Argument[] arguments, boolean configurationIdEnabled) {
        this(null, arguments, configurationIdEnabled);
    }

    protected CLI(String shellCommand, Argument[] arguments, boolean configurationIdEnabled) {
        if (!(shellCommand != null && shellCommand.trim().length() != 0 || (shellCommand = System.getProperty("app.name")) != null && shellCommand.trim().length() != 0)) {
            throw new IllegalArgumentException("shellCommand cannot be null or empty (tried system property app.name too)");
        }
        this.shellCommand = shellCommand;
        if (arguments == null) {
            arguments = new Argument[]{};
        }
        this.arguments = arguments;
        this.configurationIdEnabled = configurationIdEnabled;
    }

    public final String getShellCommand() {
        return this.shellCommand;
    }

    public final Argument[] getArguments() {
        return (Argument[])this.arguments.clone();
    }

    public final boolean isConfigurationIdEnabled() {
        return this.configurationIdEnabled;
    }

    public final void initialize() throws ProtempaStartupException {
        if (!this.configurationIdEnabled) {
            throw new IllegalStateException("Cannot initialize without a configuration id");
        }
        this.protempa = Protempa.newInstance(this.commandLine.getOptionValue("c"));
    }

    public void execute(Protempa protempa, CommandLine commandLine) throws CLIException {
    }

    public final void printException(Exception cliException) {
        System.err.print(cliException.getMessage());
        this.printCause(cliException);
    }

    private void printCause(Throwable cliException) {
        Throwable cause = cliException.getCause();
        if (cause != null && cause.getMessage() != null && cause.getMessage().length() > 0) {
            System.err.print(": ");
            System.err.println();
            System.err.print(cause.getMessage());
            this.printCause(cause);
        } else {
            System.err.println();
        }
    }

    public final void execute() throws CLIException {
        if (this.protempa == null) {
            throw new IllegalStateException("PROTEMPA not initialized.");
        }
        this.execute(this.protempa, this.commandLine);
    }

    public final void close() throws CloseException {
        if (this.protempa == null) {
            throw new IllegalStateException("PROTEMPA not initialized");
        }
        this.protempa.close();
        this.protempa = null;
    }

    public final CommandLine processOptionsAndArgs(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("args cannot be null");
        }
        Options cliOptions = this.constructCliOptions();
        PosixParser parser = new PosixParser();
        try {
            this.commandLine = parser.parse(cliOptions, args);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            System.exit(1);
        }
        String commandLineSyntax = this.commandLineSyntax(this.arguments);
        if (this.commandLine.hasOption("h")) {
            new HelpFormatter().printHelp(commandLineSyntax, cliOptions);
            System.exit(0);
        }
        if (this.configurationIdEnabled && !this.commandLine.hasOption("c")) {
            System.err.println("missing option: c");
            System.exit(1);
        }
        this.checkInvalidArguments(this.arguments);
        return this.commandLine;
    }

    public final void initializeExecuteAndClose() {
        try {
            this.initialize();
        }
        catch (ProtempaStartupException ex) {
            this.printException(ex);
            System.exit(1);
        }
        boolean error = false;
        try {
            this.execute();
            this.close();
        }
        catch (CloseException | CLIException ex) {
            this.printException(ex);
            error = true;
        }
        finally {
            if (error) {
                try {
                    this.close();
                }
                catch (CloseException closeException) {}
            }
        }
        if (error) {
            System.exit(1);
        }
    }

    protected void addCustomCliOptions(Options options) {
    }

    private String commandLineSyntax(Argument[] arguments) {
        StringBuilder argumentStringBuilder = new StringBuilder();
        if (arguments.length > 0) {
            argumentStringBuilder.append(' ');
        }
        for (int i = 0; i < arguments.length; ++i) {
            argumentStringBuilder.append(arguments[i].getFormatted());
            if (i >= arguments.length - 1) continue;
            argumentStringBuilder.append(' ');
        }
        String commandLineSyntax = this.shellCommand + " [options]" + argumentStringBuilder.toString();
        return commandLineSyntax;
    }

    private Options constructCliOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "print this message");
        if (this.configurationIdEnabled) {
            options.addOption("c", "configuration", true, "PROTEMPA configuration id");
        }
        this.addCustomCliOptions(options);
        return options;
    }

    private void checkInvalidArguments(Argument[] arguments) {
        String[] leftOverArgs = this.commandLine.getArgs();
        ArrayList<Argument> requiredArguments = new ArrayList<Argument>();
        for (Argument argument : arguments) {
            if (!argument.isRequired()) continue;
            requiredArguments.add(argument);
        }
        ArrayList<String> missingRequiredArgs = new ArrayList<String>();
        if (leftOverArgs.length < requiredArguments.size()) {
            int n = requiredArguments.size();
            for (int i = leftOverArgs.length; i < n; ++i) {
                missingRequiredArgs.add(((Argument)requiredArguments.get(i)).getName());
            }
        }
        if (!missingRequiredArgs.isEmpty()) {
            System.err.println("Missing argument(s): " + StringUtils.join(missingRequiredArgs, (String)", "));
            System.exit(1);
        }
        if (leftOverArgs.length > arguments.length) {
            ArrayList<String> extraArgs = new ArrayList<String>();
            for (int i = arguments.length; i < leftOverArgs.length; ++i) {
                extraArgs.add(leftOverArgs[i]);
            }
            System.err.println("Invalid extra argument(s): " + StringUtils.join(extraArgs, (String)","));
            System.exit(1);
        }
    }

    public static final class Argument {
        private final String name;
        private final boolean required;

        public Argument(String name, boolean required) {
            if (name == null || name.trim().length() == 0) {
                throw new IllegalArgumentException("name cannot be null or empty");
            }
            this.name = name;
            this.required = required;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String getFormatted() {
            if (this.required) {
                return this.name;
            }
            return '[' + this.name + ']';
        }
    }
}

