/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.SourceId;

public final class DataSourceBackendId
extends SourceId {
    private static Map<String, DataSourceBackendId> cache = new HashMap<String, DataSourceBackendId>();
    private final String id;
    private volatile transient int hashCode;

    public static DataSourceBackendId getInstance(String id) {
        DataSourceBackendId result = cache.get(id);
        if (result == null) {
            id = id.intern();
            result = new DataSourceBackendId(id);
            cache.put(id, result);
        }
        return result;
    }

    @Override
    String getId() {
        return this.id;
    }

    private DataSourceBackendId(String newId) {
        if (newId == null) {
            throw new IllegalArgumentException("newId cannot be null");
        }
        this.id = newId;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            this.hashCode = result = 37 * result + this.id.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataSourceBackendId other = (DataSourceBackendId)obj;
        return this.id.equals(other.id);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

