/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections4.CollectionUtils;
import org.protempa.AbstractionFinder;
import org.protempa.AlgorithmSource;
import org.protempa.AlgorithmSourceImpl;
import org.protempa.CloseException;
import org.protempa.DataSource;
import org.protempa.DataSourceFailedConfigurationValidationException;
import org.protempa.DataSourceFailedDataValidationException;
import org.protempa.DataSourceImpl;
import org.protempa.DataSourceValidationIncompleteException;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceImpl;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.ProtempaEventListener;
import org.protempa.ProtempaStartupException;
import org.protempa.ProtempaUtil;
import org.protempa.QueryException;
import org.protempa.SourceFactory;
import org.protempa.backend.BackendProviderSpecLoaderException;
import org.protempa.backend.ConfigurationsLoadException;
import org.protempa.backend.ConfigurationsNotFoundException;
import org.protempa.backend.DataSourceBackendFailedConfigurationValidationException;
import org.protempa.backend.DataSourceBackendFailedDataValidationException;
import org.protempa.backend.InvalidConfigurationException;
import org.protempa.backend.asb.AlgorithmSourceBackend;
import org.protempa.backend.dsb.DataSourceBackend;
import org.protempa.backend.dsb.DataValidationEvent;
import org.protempa.backend.ksb.KnowledgeSourceBackend;
import org.protempa.dest.Destination;
import org.protempa.dest.GetSupportedPropositionIdsException;
import org.protempa.query.Query;
import org.protempa.query.QueryBuildException;
import org.protempa.query.QueryBuilder;

public final class Protempa
implements AutoCloseable {
    private static final String STARTUP_FAILURE_MSG = "PROTEMPA could not start up";
    private final AbstractionFinder abstractionFinder;
    private final List<ProtempaEventListener> eventListeners = new ArrayList<ProtempaEventListener>();

    public static Protempa newInstance(String configurationId) throws ProtempaStartupException {
        try {
            return Protempa.newInstance(new SourceFactory(configurationId));
        }
        catch (BackendProviderSpecLoaderException | ConfigurationsLoadException | ConfigurationsNotFoundException | InvalidConfigurationException ex) {
            throw new ProtempaStartupException(STARTUP_FAILURE_MSG, ex);
        }
    }

    public static Protempa newInstance(SourceFactory sourceFactory) throws ProtempaStartupException {
        try {
            FutureTask<DataSource> newDataSourceInstance = new FutureTask<DataSource>(() -> sourceFactory.newDataSourceInstance());
            newDataSourceInstance.run();
            FutureTask<KnowledgeSource> newKnowledgeSourceInstance = new FutureTask<KnowledgeSource>(() -> sourceFactory.newKnowledgeSourceInstance());
            newKnowledgeSourceInstance.run();
            FutureTask<AlgorithmSource> newAlgorithmSourceInstance = new FutureTask<AlgorithmSource>(() -> sourceFactory.newAlgorithmSourceInstance());
            newAlgorithmSourceInstance.run();
            return new Protempa(newDataSourceInstance.get(), newKnowledgeSourceInstance.get(), newAlgorithmSourceInstance.get());
        }
        catch (InterruptedException ex) {
            throw new ProtempaStartupException(STARTUP_FAILURE_MSG, ex);
        }
        catch (ExecutionException ex) {
            throw new ProtempaStartupException(STARTUP_FAILURE_MSG, ex.getCause());
        }
    }

    public Protempa(DataSource dataSource, KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) throws ProtempaStartupException {
        DataSource ds = dataSource == null ? new DataSourceImpl(new DataSourceBackend[0]) : dataSource;
        KnowledgeSource ks = knowledgeSource == null ? new KnowledgeSourceImpl(new KnowledgeSourceBackend[0]) : knowledgeSource;
        AlgorithmSource as = algorithmSource == null ? new AlgorithmSourceImpl(new AlgorithmSourceBackend[0]) : algorithmSource;
        try {
            this.abstractionFinder = new AbstractionFinder(ds, ks, as, this.eventListeners);
        }
        catch (KnowledgeSourceReadException ex) {
            throw new ProtempaStartupException(STARTUP_FAILURE_MSG, ex);
        }
    }

    public DataSource getDataSource() {
        return this.abstractionFinder.getDataSource();
    }

    public KnowledgeSource getKnowledgeSource() {
        return this.abstractionFinder.getKnowledgeSource();
    }

    public AlgorithmSource getAlgorithmSource() {
        return this.abstractionFinder.getAlgorithmSource();
    }

    public void addEventListener(ProtempaEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    public void removeEventListener(ProtempaEventListener eventListener) {
        this.eventListeners.remove(eventListener);
    }

    public Query buildQuery(QueryBuilder queryBuilder) throws QueryBuildException {
        return this.abstractionFinder.buildQuery(queryBuilder);
    }

    public String[] getSupportedPropositionIds(Destination destination) throws GetSupportedPropositionIdsException {
        return destination.getSupportedPropositionIds(this.abstractionFinder.getDataSource(), this.abstractionFinder.getKnowledgeSource());
    }

    public void execute(Query query, Destination destination) throws QueryException {
        if (query == null) {
            throw new IllegalArgumentException("query cannot be null");
        }
        if (destination == null) {
            throw new IllegalArgumentException("resultsHandler cannot be null");
        }
        Logger logger = ProtempaUtil.logger();
        logger.log(Level.INFO, "Executing query {0}", query.getName());
        this.abstractionFinder.doFind(query, destination);
        logger.log(Level.INFO, "Query {0} execution complete", query.getName());
    }

    public void cancel() {
        this.abstractionFinder.cancel();
    }

    public void validateDataSourceBackendConfigurations() throws DataSourceValidationIncompleteException, DataSourceFailedConfigurationValidationException {
        KnowledgeSource knowledgeSource = this.getKnowledgeSource();
        try {
            for (DataSourceBackend backend : (DataSourceBackend[])this.getDataSource().getBackends()) {
                backend.validateConfiguration(knowledgeSource);
            }
        }
        catch (DataSourceBackendFailedConfigurationValidationException ex) {
            throw new DataSourceFailedConfigurationValidationException("Data source configuration failed validation", ex);
        }
        catch (KnowledgeSourceReadException ex) {
            throw new DataSourceValidationIncompleteException("An error occurred during validation", ex);
        }
    }

    public DataValidationEvent[] validateDataSourceBackendData() throws DataSourceFailedDataValidationException, DataSourceValidationIncompleteException {
        KnowledgeSource knowledgeSource = this.getKnowledgeSource();
        ArrayList validationEvents = new ArrayList();
        try {
            for (DataSourceBackend backend : (DataSourceBackend[])this.getDataSource().getBackends()) {
                CollectionUtils.addAll(validationEvents, (Object[])backend.validateData(knowledgeSource));
            }
        }
        catch (DataSourceBackendFailedDataValidationException ex) {
            throw new DataSourceFailedDataValidationException("Data source failed validation", ex, validationEvents.toArray(new DataValidationEvent[validationEvents.size()]));
        }
        catch (KnowledgeSourceReadException ex) {
            throw new DataSourceValidationIncompleteException("An error occurred during validation", ex);
        }
        return validationEvents.toArray(new DataValidationEvent[validationEvents.size()]);
    }

    @Override
    public void close() throws CloseException {
        this.abstractionFinder.close();
        ProtempaUtil.logger().info("Protempa closed");
    }

    public void clear() {
        this.abstractionFinder.getAlgorithmSource().clear();
        this.abstractionFinder.getDataSource().clear();
        this.abstractionFinder.getKnowledgeSource().clear();
        ProtempaUtil.logger().fine("Protempa cleared");
    }
}

