/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.StatefulSession;
import org.eurekaclinical.datastore.DataStore;
import org.protempa.AbstractExecutionStrategy;
import org.protempa.AlgorithmSource;
import org.protempa.DerivationsBuilder;
import org.protempa.ExecutionStrategyInitializationException;
import org.protempa.ExecutionStrategyShutdownException;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.datastore.WorkingMemoryDataStores;
import org.protempa.proposition.Proposition;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;

class StatefulExecutionStrategy
extends AbstractExecutionStrategy {
    private final File databasePath;
    private DataStore<String, StatefulSession> dataStore;
    private WorkingMemoryDataStores workingMemoryStoreCreator;
    private StatefulSession workingMemory;
    private final QueryMode queryMode;

    StatefulExecutionStrategy(AlgorithmSource algorithmSource, Query query) {
        super(algorithmSource);
        assert (query != null) : "query cannot be null";
        String dbPath = query.getDatabasePath();
        assert (dbPath != null) : "query.getDatabasePath() cannot return a null value";
        this.databasePath = new File(dbPath);
        this.queryMode = query.getQueryMode();
    }

    @Override
    public void initialize(Collection<PropositionDefinition> allNarrowerDescendants, DerivationsBuilder listener) throws ExecutionStrategyInitializationException {
        super.initialize(allNarrowerDescendants, listener);
        this.workingMemoryStoreCreator = new WorkingMemoryDataStores(this.getRuleBase(), this.databasePath.getParent());
        try {
            this.dataStore = this.workingMemoryStoreCreator.getDataStore(this.databasePath.getName());
            if (this.queryMode == QueryMode.REPLACE) {
                this.dataStore.clear();
            }
        }
        catch (IOException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
    }

    @Override
    public Iterator<Proposition> execute(String keyId, Set<String> propositionIds, List<?> objects) {
        Logger logger = ProtempaUtil.logger();
        this.workingMemory = (StatefulSession)this.dataStore.get((Object)keyId);
        if (this.workingMemory == null) {
            this.workingMemory = this.getRuleBase().newStatefulSession(false);
        }
        this.workingMemory.setGlobal("keyId", (Object)keyId);
        for (Object obj : objects) {
            this.workingMemory.insert(obj);
        }
        this.workingMemory.fireAllRules();
        logger.log(Level.FINEST, "Persisting working memory for key ID {0}", keyId);
        this.dataStore.put((Object)keyId, (Object)this.workingMemory);
        logger.log(Level.FINEST, "Persisted working memory for key ID {0}", keyId);
        return this.workingMemory.iterateObjects();
    }

    @Override
    public void closeCurrentWorkingMemory() {
        this.workingMemory.dispose();
    }

    @Override
    public void shutdown() throws ExecutionStrategyShutdownException {
        ExecutionStrategyShutdownException exception = null;
        try {
            this.dataStore.close();
        }
        catch (IOError err) {
            exception = new ExecutionStrategyShutdownException(err);
        }
        try {
            this.workingMemoryStoreCreator.close();
        }
        catch (IOException ex) {
            if (exception != null) {
                exception.addSuppressed(new ExecutionStrategyShutdownException(ex));
            }
            exception = new ExecutionStrategyShutdownException(ex);
        }
        if (exception != null) {
            throw exception;
        }
    }
}

