/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.arrays.Arrays;
import org.drools.FactException;
import org.drools.WorkingMemory;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.protempa.AbstractParameterFactory;
import org.protempa.DerivationsBuilder;
import org.protempa.HighLevelAbstractionFinder;
import org.protempa.JBossRulesDerivedLocalUniqueIdValuesProvider;
import org.protempa.ProtempaUtil;
import org.protempa.SequentialTemporalPatternDefinition;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPatternOffset;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.ProviderBasedUniqueIdFactory;
import org.protempa.proposition.Segment;
import org.protempa.proposition.Sequence;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.interval.Relation;

class SequentialTemporalPatternConsequence
implements Consequence {
    private static final long serialVersionUID = -833609244124008166L;
    private final SequentialTemporalPatternDefinition def;
    private final TemporalExtendedPropositionDefinition[] epds;
    private final DerivationsBuilder derivationsBuilder;
    private int parameterMapCapacity;
    private List<List<TemporalExtendedPropositionDefinition>> epdPairs;
    private Map<List<TemporalExtendedPropositionDefinition>, Relation> epdToRelation;

    SequentialTemporalPatternConsequence(SequentialTemporalPatternDefinition def, DerivationsBuilder derivationsBuilder) {
        assert (def != null) : "def cannot be null";
        this.def = def;
        SequentialTemporalPatternDefinition.SubsequentTemporalExtendedPropositionDefinition[] relatedTemporalExtendedPropositionDefinitions = def.getSubsequentTemporalExtendedPropositionDefinitions();
        TemporalExtendedPropositionDefinition[] epds = new TemporalExtendedPropositionDefinition[relatedTemporalExtendedPropositionDefinitions.length + 1];
        assert (epds != null) : "epds cannot be null";
        assert (epds.length > 0) : "epds must be > 0";
        epds[0] = def.getFirstTemporalExtendedPropositionDefinition();
        for (int i = 1; i < epds.length; ++i) {
            epds[i] = relatedTemporalExtendedPropositionDefinitions[i - 1].getRelatedTemporalExtendedPropositionDefinition();
        }
        this.epds = epds;
        this.derivationsBuilder = derivationsBuilder;
        this.parameterMapCapacity = this.epds.length * 4 / 3 + 1;
        this.epdPairs = new ArrayList<List<TemporalExtendedPropositionDefinition>>();
        this.epdToRelation = new HashMap<List<TemporalExtendedPropositionDefinition>, Relation>(this.parameterMapCapacity);
        TemporalExtendedPropositionDefinition lhs = def.getFirstTemporalExtendedPropositionDefinition();
        assert (lhs != null) : "mainTemporalExtendedPropositionDefinition cannot be null";
        for (SequentialTemporalPatternDefinition.SubsequentTemporalExtendedPropositionDefinition rhsr : def.getSubsequentTemporalExtendedPropositionDefinitions()) {
            TemporalExtendedPropositionDefinition rhs = rhsr.getRelatedTemporalExtendedPropositionDefinition();
            List asList = Arrays.asList((Object[][])new TemporalExtendedPropositionDefinition[][]{{lhs, rhs}});
            this.epdPairs.add(asList);
            this.epdToRelation.put(asList, rhsr.getRelation());
            lhs = rhs;
        }
    }

    public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory arg1) throws Exception {
        int i;
        List tps = (List)knowledgeHelper.get(knowledgeHelper.getDeclaration("result"));
        Collections.sort(tps, ProtempaUtil.TEMP_PROP_COMP);
        HashMap<TemporalExtendedPropositionDefinition, TemporalProposition> propositionMap = new HashMap<TemporalExtendedPropositionDefinition, TemporalProposition>(this.parameterMapCapacity);
        JBossRulesDerivedLocalUniqueIdValuesProvider provider = new JBossRulesDerivedLocalUniqueIdValuesProvider(arg1, this.def.getPropositionId());
        ProviderBasedUniqueIdFactory factory = new ProviderBasedUniqueIdFactory(provider);
        int l = this.epds.length;
        int n = tps.size() - l + 1;
        block0: for (i = 0; i < n; ++i) {
            List<TemporalProposition> subList = tps.subList(i, i + l);
            for (int j = 0; j < l; ++j) {
                TemporalProposition p = (TemporalProposition)subList.get(j);
                if (!p.getId().equals(this.epds[j].getPropositionId())) continue block0;
                propositionMap.put(this.epds[j], p);
            }
            if (!HighLevelAbstractionFinder.find(this.epdToRelation, this.epdPairs, propositionMap)) continue;
            this.assertProposition(subList, knowledgeHelper, factory.getInstance());
        }
        if (this.def.isAllowPartialMatches()) {
            int j;
            List<TemporalProposition> subList = tps.subList(i, tps.size());
            propositionMap.clear();
            int n2 = subList.size();
            for (j = 0; j < n2; ++j) {
                propositionMap.put(this.epds[j], (TemporalProposition)subList.get(j));
            }
            n2 = this.epdPairs.size();
            for (j = 0; j < n2; ++j) {
                List<TemporalExtendedPropositionDefinition> pair = this.epdPairs.get(j);
                TemporalProposition a1 = (TemporalProposition)propositionMap.get(pair.get(0));
                TemporalProposition a2 = (TemporalProposition)propositionMap.get(pair.get(1));
                if (a1 == null || a2 == null || this.epdToRelation.get(pair).hasRelation(a1.getInterval(), a2.getInterval())) continue;
                return;
            }
            this.assertProposition(subList, knowledgeHelper, factory.getInstance());
        }
    }

    private void assertProposition(List<TemporalProposition> subList, KnowledgeHelper knowledgeHelper, UniqueId uniqueId) throws FactException {
        Logger logger = ProtempaUtil.logger();
        Segment<TemporalProposition> segment = new Segment<TemporalProposition>(new Sequence<TemporalProposition>(this.def.getPropositionId(), subList));
        TemporalPatternOffset temporalOffset = this.def.getTemporalOffset();
        AbstractParameter result = AbstractParameterFactory.getFromAbstraction(this.def.getPropositionId(), uniqueId, segment, subList, null, temporalOffset, this.epds, null);
        knowledgeHelper.insertLogical((Object)result);
        for (Proposition proposition : segment) {
            this.derivationsBuilder.propositionAsserted(proposition, result);
        }
        logger.log(Level.FINER, "Asserted derived proposition {0}", result);
    }
}

