/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.Tuple;
import org.protempa.AbstractParameterFactory;
import org.protempa.DerivationsBuilder;
import org.protempa.ExtendedPropositionDefinition;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.JBossRulesDerivedLocalUniqueIdValuesProvider;
import org.protempa.ProtempaUtil;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPatternOffset;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.ProviderBasedUniqueIdFactory;
import org.protempa.proposition.Segment;
import org.protempa.proposition.Sequence;
import org.protempa.proposition.TemporalProposition;

class HighLevelAbstractionConsequence
implements Consequence {
    private static final long serialVersionUID = -833609244124008166L;
    private final HighLevelAbstractionDefinition cad;
    private final int columns;
    private final ExtendedPropositionDefinition[] epds;
    private final DerivationsBuilder derivationsBuilder;

    HighLevelAbstractionConsequence(HighLevelAbstractionDefinition def, ExtendedPropositionDefinition[] epds, DerivationsBuilder derivationsBuilder) {
        assert (def != null) : "def cannot be null";
        assert (epds != null) : "epds cannot be null";
        int col = epds.length;
        assert (col > 0) : "columns must be > 0, was " + col;
        this.cad = def;
        this.columns = col;
        this.epds = epds;
        this.derivationsBuilder = derivationsBuilder;
    }

    public void evaluate(KnowledgeHelper kh, WorkingMemory wm) throws Exception {
        Logger logger = ProtempaUtil.logger();
        List<Proposition> ps = this.parameters(kh.getTuple(), wm);
        List<TemporalProposition> tps = this.extractTemporalPropositions(ps);
        List<TemporalExtendedPropositionDefinition> tepdsL = this.extractTemporalExtendedPropositionDefinitions();
        TemporalExtendedPropositionDefinition[] tepds = tepdsL.toArray(new TemporalExtendedPropositionDefinition[tepdsL.size()]);
        Segment<TemporalProposition> segment = new Segment<TemporalProposition>(new Sequence<TemporalProposition>(this.cad.getPropositionId(), tps));
        TemporalPatternOffset temporalOffset = this.cad.getTemporalOffset();
        JBossRulesDerivedLocalUniqueIdValuesProvider provider = new JBossRulesDerivedLocalUniqueIdValuesProvider(wm, this.cad.getPropositionId());
        ProviderBasedUniqueIdFactory factory = new ProviderBasedUniqueIdFactory(provider);
        AbstractParameter result = AbstractParameterFactory.getFromAbstraction(this.cad.getPropositionId(), factory.getInstance(), segment, tps, null, temporalOffset, tepds, null);
        kh.insertLogical((Object)result);
        for (Proposition proposition : segment) {
            this.derivationsBuilder.propositionAsserted(proposition, result);
        }
        logger.log(Level.FINER, "Asserted derived proposition {0}", result);
    }

    private List<Proposition> parameters(Tuple arg0, WorkingMemory arg1) {
        ArrayList<Proposition> sequences = new ArrayList<Proposition>(this.columns);
        for (int i = 0; i < this.columns; ++i) {
            sequences.add((Proposition)arg1.getObject((FactHandle)arg0.get(i)));
        }
        return sequences;
    }

    private List<TemporalProposition> extractTemporalPropositions(List<Proposition> ps) {
        ArrayList<TemporalProposition> tps = new ArrayList<TemporalProposition>();
        for (Proposition prop : ps) {
            if (!(prop instanceof TemporalProposition)) continue;
            tps.add((TemporalProposition)prop);
        }
        return tps;
    }

    private List<TemporalExtendedPropositionDefinition> extractTemporalExtendedPropositionDefinitions() {
        ArrayList<TemporalExtendedPropositionDefinition> tepdsL = new ArrayList<TemporalExtendedPropositionDefinition>();
        for (ExtendedPropositionDefinition epd : this.epds) {
            if (!(epd instanceof TemporalExtendedPropositionDefinition)) continue;
            tepdsL.add((TemporalExtendedPropositionDefinition)epd);
        }
        return tepdsL;
    }
}

