/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.event.DefaultWorkingMemoryEventListener;
import org.drools.event.ObjectRetractedEvent;
import org.protempa.ProtempaUtil;
import org.protempa.SetDeleteDatePropositionVisitor;
import org.protempa.proposition.Proposition;

final class DeletedWorkingMemoryEventListener
extends DefaultWorkingMemoryEventListener {
    private final List<Proposition> propsToDelete = new ArrayList<Proposition>();
    private final Logger logger = ProtempaUtil.logger();
    private final SetDeleteDatePropositionVisitor setDeleteDatePropVisitor = new SetDeleteDatePropositionVisitor();

    public void objectRetracted(ObjectRetractedEvent ore) {
        String name = ore.getPropagationContext().getRuleOrigin().getName();
        if (name.equals("DELETE_PROPOSITION")) {
            Proposition prop = (Proposition)ore.getOldObject();
            this.logger.log(Level.FINEST, "Deleted proposition {0}", prop);
            prop.accept(this.setDeleteDatePropVisitor);
            this.propsToDelete.add(this.setDeleteDatePropVisitor.getDeleted());
        }
    }

    List<Proposition> getPropsToDelete() {
        return new ArrayList<Proposition>(this.propsToDelete);
    }

    void clear() {
        this.propsToDelete.clear();
    }
}

