/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.datastore;

import java.io.ByteArrayInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.eurekaclinical.datastore.DataStore;
import org.eurekaclinical.datastore.DataStoreFactory;

public final class DroolsWorkingMemoryStore
implements DataStore<String, StatefulSession> {
    private final DataStore<String, byte[]> store;
    private boolean isClosed;
    private final RuleBase ruleBase;

    public DroolsWorkingMemoryStore(DataStoreFactory storeFactory, String dbName, RuleBase ruleBase) throws IOException {
        this.store = storeFactory.getInstance(dbName);
        this.isClosed = false;
        this.ruleBase = ruleBase;
    }

    public void close() {
        this.store.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StatefulSession readWorkingMemory(byte[] barr) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(barr);){
            StatefulSession statefulSession = this.ruleBase.newStatefulSession((InputStream)bais, false);
            return statefulSession;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new IOError(ex);
        }
    }

    public StatefulSession get(Object key) {
        byte[] result = (byte[])this.store.get(key);
        if (result != null) {
            return this.readWorkingMemory(result);
        }
        return null;
    }

    public StatefulSession put(String key, StatefulSession value) {
        try {
            this.store.put((Object)key, (Object)SerializationUtils.serialize((Serializable)value));
            return value;
        }
        catch (SerializationException ex) {
            throw new IOError(ex);
        }
    }

    public int size() {
        return this.store.size();
    }

    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.store.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.store.containsValue(value);
    }

    public StatefulSession remove(Object key) {
        return this.readWorkingMemory((byte[])this.store.remove(key));
    }

    public void putAll(Map<? extends String, ? extends StatefulSession> m) {
        for (Map.Entry<? extends String, ? extends StatefulSession> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public void clear() {
        this.store.clear();
    }

    public Set<String> keySet() {
        return this.store.keySet();
    }

    public Collection<StatefulSession> values() {
        ArrayList<StatefulSession> values = new ArrayList<StatefulSession>();
        for (byte[] barr : this.store.values()) {
            values.add(this.readWorkingMemory(barr));
        }
        return Collections.unmodifiableCollection(values);
    }

    public Set<Map.Entry<String, StatefulSession>> entrySet() {
        HashSet<Map.Entry<String, StatefulSession>> entrySet = new HashSet<Map.Entry<String, StatefulSession>>();
        for (String key : this.store.keySet()) {
            entrySet.add(new LazyEntry(key));
        }
        return entrySet;
    }

    private class LazyEntry
    implements Map.Entry<String, StatefulSession> {
        private final String key;

        public LazyEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public StatefulSession getValue() {
            return DroolsWorkingMemoryStore.this.readWorkingMemory((byte[])DroolsWorkingMemoryStore.this.store.get((Object)this.key));
        }

        @Override
        public StatefulSession setValue(StatefulSession value) {
            throw new UnsupportedOperationException("setValue not supported");
        }
    }
}

