/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.deid;

import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.protempa.Attribute;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.dest.deid.DeidAttributes;
import org.protempa.dest.deid.EncryptException;
import org.protempa.dest.deid.Encryption;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.AbstractProposition;
import org.protempa.proposition.Constant;
import org.protempa.proposition.Context;
import org.protempa.proposition.Event;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.interval.AbsoluteTimeIntervalFactory;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.AbsoluteTimeGranularityUtil;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.NumericalValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueType;
import org.protempa.proposition.visitor.AbstractPropositionVisitor;

class PropositionDeidentifierVisitor
extends AbstractPropositionVisitor {
    private static final AbsoluteTimeIntervalFactory INTERVAL_FACTORY = new AbsoluteTimeIntervalFactory();
    private AbstractProposition deidentifiedProp;
    private final Encryption encryption;
    private final Integer offsetInSeconds;
    private final Map<String, PropositionDefinition> propDefCache;
    private static final Calendar CAL = Calendar.getInstance();
    private static final Calendar AGE_OVER_89_CAL = Calendar.getInstance();
    private static final Date AGE_OVER_89;
    private String keyId;

    PropositionDeidentifierVisitor(Encryption encryption, Map<String, PropositionDefinition> propDefCache, Integer offsetInSeconds) {
        assert (encryption != null) : "encryption cannot be null";
        assert (propDefCache != null) : "propDefCache cannot be null";
        this.encryption = encryption;
        this.propDefCache = propDefCache;
        this.offsetInSeconds = offsetInSeconds;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    @Override
    public void visit(Context context) {
        Context deidentifiedContext = new Context(context.getId(), context.getUniqueId());
        deidentifiedContext.setInterval(this.doOffsetInterval(context.getInterval()));
        this.visitCommon(context, deidentifiedContext);
    }

    @Override
    public void visit(Constant constant) {
        Constant deidentifiedConstant = new Constant(constant.getId(), constant.getUniqueId());
        this.visitCommon(constant, deidentifiedConstant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visit(PrimitiveParameter primitiveParameter) {
        PrimitiveParameter deidentifiedPrimitiveParameter = new PrimitiveParameter(primitiveParameter.getId(), primitiveParameter.getUniqueId());
        deidentifiedPrimitiveParameter.setGranularity(primitiveParameter.getGranularity());
        deidentifiedPrimitiveParameter.setValue(primitiveParameter.getValue());
        if (this.offsetInSeconds != null) {
            Calendar calendar = CAL;
            synchronized (calendar) {
                CAL.setTime(AbsoluteTimeGranularityUtil.asDate(primitiveParameter.getPosition()));
                CAL.add(13, this.offsetInSeconds);
                Date time = CAL.getTime();
                deidentifiedPrimitiveParameter.setPosition(AbsoluteTimeGranularityUtil.asPosition(time));
            }
        } else {
            deidentifiedPrimitiveParameter.setPosition(primitiveParameter.getPosition());
        }
        this.visitCommon(primitiveParameter, deidentifiedPrimitiveParameter);
    }

    @Override
    public void visit(Event event) {
        Event deidentifiedEvent = new Event(event.getId(), event.getUniqueId());
        deidentifiedEvent.setInterval(this.doOffsetInterval(event.getInterval()));
        this.visitCommon(event, deidentifiedEvent);
    }

    @Override
    public void visit(AbstractParameter abstractParameter) {
        AbstractParameter deidentifiedAbstractParameter = new AbstractParameter(abstractParameter.getId(), abstractParameter.getUniqueId());
        deidentifiedAbstractParameter.setContextId(abstractParameter.getContextId());
        deidentifiedAbstractParameter.setValue(abstractParameter.getValue());
        deidentifiedAbstractParameter.setInterval(this.doOffsetInterval(abstractParameter.getInterval()));
        this.visitCommon(abstractParameter, deidentifiedAbstractParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Interval doOffsetInterval(Interval interval) {
        if (this.offsetInSeconds != null) {
            Date maxFinishDate;
            Date minFinishDate;
            Date maxStartDate;
            Date minStartDate = AbsoluteTimeGranularityUtil.asDate(interval.getMinStart());
            if (minStartDate != null) {
                Calendar calendar = CAL;
                synchronized (calendar) {
                    CAL.setTime(minStartDate);
                    CAL.add(13, this.offsetInSeconds);
                    minStartDate = CAL.getTime();
                }
            }
            if ((maxStartDate = AbsoluteTimeGranularityUtil.asDate(interval.getMaxStart())) != null) {
                Calendar calendar = CAL;
                synchronized (calendar) {
                    CAL.setTime(maxStartDate);
                    CAL.add(13, this.offsetInSeconds);
                    maxStartDate = CAL.getTime();
                }
            }
            if ((minFinishDate = AbsoluteTimeGranularityUtil.asDate(interval.getMinFinish())) != null) {
                Calendar calendar = CAL;
                synchronized (calendar) {
                    CAL.setTime(minFinishDate);
                    CAL.add(13, this.offsetInSeconds);
                    minFinishDate = CAL.getTime();
                }
            }
            if ((maxFinishDate = AbsoluteTimeGranularityUtil.asDate(interval.getMaxFinish())) != null) {
                Calendar calendar = CAL;
                synchronized (calendar) {
                    CAL.setTime(maxFinishDate);
                    CAL.add(13, this.offsetInSeconds);
                    maxFinishDate = CAL.getTime();
                }
            }
            return INTERVAL_FACTORY.getInstance(minStartDate, maxStartDate, interval.getStartGranularity(), minFinishDate, maxFinishDate, interval.getFinishGranularity());
        }
        return interval;
    }

    public Proposition getProposition() {
        return this.deidentifiedProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitCommon(AbstractProposition prop, AbstractProposition deidentifiedProp) {
        deidentifiedProp.setCreateDate(prop.getCreateDate());
        deidentifiedProp.setDownloadDate(prop.getDownloadDate());
        deidentifiedProp.setUpdateDate(prop.getUpdateDate());
        deidentifiedProp.setSourceSystem(prop.getSourceSystem());
        PropositionDefinition propDef = this.propDefCache.get(prop.getId());
        for (String name : prop.getPropertyNames()) {
            Value propertyValue = prop.getProperty(name);
            PropertyDefinition propertyDefinition = propDef.propertyDefinition(name);
            if (propertyDefinition != null) {
                Attribute hipaaIdAttr = propertyDefinition.getAttribute("is-HIPAA-identifier");
                Attribute hipaaIdTypeAttr = propertyDefinition.getAttribute("HIPAA-identifier-type");
                if (propertyValue == null) {
                    deidentifiedProp.setProperty(name, propertyValue);
                    continue;
                }
                if (this.offsetInSeconds != null && propertyDefinition.getValueType() == ValueType.DATEVALUE) {
                    Calendar calendar = CAL;
                    synchronized (calendar) {
                        CAL.setTime(((DateValue)propertyValue).getDate());
                        if (CAL.before(AGE_OVER_89_CAL)) {
                            deidentifiedProp.setProperty(name, DateValue.getInstance(AGE_OVER_89));
                        } else {
                            CAL.add(13, this.offsetInSeconds);
                            deidentifiedProp.setProperty(name, DateValue.getInstance(CAL.getTime()));
                        }
                        continue;
                    }
                }
                if (hipaaIdTypeAttr != null && DeidAttributes.AGE.equals(hipaaIdTypeAttr.getValue())) {
                    NumericalValue numericalValue = (NumericalValue)propertyValue;
                    if (numericalValue.compare(NumberValue.getInstance(90L)) == ValueComparator.GREATER_THAN_OR_EQUAL_TO) {
                        deidentifiedProp.setProperty(name, new InequalityNumberValue(ValueComparator.GREATER_THAN_OR_EQUAL_TO, 90.0));
                        continue;
                    }
                    deidentifiedProp.setProperty(name, propertyValue);
                    continue;
                }
                if (hipaaIdAttr != null && BooleanValue.TRUE.equals(hipaaIdAttr.getValue())) {
                    try {
                        deidentifiedProp.setProperty(name, NominalValue.getInstance(this.encryption.encrypt(this.keyId, propertyValue.getFormatted())));
                        continue;
                    }
                    catch (EncryptException ex) {
                        throw new AssertionError((Object)ex);
                    }
                }
                deidentifiedProp.setProperty(name, propertyValue);
                continue;
            }
            deidentifiedProp.setProperty(name, propertyValue);
        }
        for (String name : prop.getReferenceNames()) {
            deidentifiedProp.setReferences(name, prop.getReferences(name));
        }
        this.deidentifiedProp = deidentifiedProp;
    }

    static {
        AGE_OVER_89_CAL.add(1, -90);
        AGE_OVER_89 = AGE_OVER_89_CAL.getTime();
    }
}

