/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import org.protempa.PropositionDefinition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.comparator.TemporalPropositionIntervalComparator;

public final class ProtempaUtil {
    static final Comparator<TemporalProposition> TEMP_PROP_COMP = new TemporalPropositionIntervalComparator();
    static final Comparator<TemporalProposition> REVERSE_TEMP_PROP_COMP = Collections.reverseOrder(TEMP_PROP_COMP);

    private ProtempaUtil() {
    }

    public static void checkArray(Object[] array, String arrayName) {
        if (array == null) {
            throw new IllegalArgumentException(arrayName + " cannot be null");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException(arrayName + " cannot be empty");
        }
        ProtempaUtil.checkArrayForNullElement(array, arrayName);
    }

    public static void checkArrayForNullElement(Object[] array, String arrayName) {
        for (Object elt : array) {
            if (elt != null) continue;
            throw new IllegalArgumentException(arrayName + " cannot contain null values");
        }
    }

    static void checkArrayForDuplicates(Object[] array, String arrayName) {
        if (array.length > 1) {
            if (array.length == 2) {
                if (array[0] == array[1] || array[0] != null && array[0].equals(array[1])) {
                    throw new IllegalArgumentException(arrayName + " cannot contain duplicate elements: " + Arrays.toString(array) + "; " + array[0]);
                }
            } else {
                HashSet<Object> set = new HashSet<Object>();
                for (Object obj : array) {
                    if (set.add(obj)) continue;
                    throw new IllegalArgumentException(arrayName + " cannot contain duplicate elements: " + Arrays.toString(array) + "; " + obj);
                }
            }
        }
    }

    public static void internAll(String[] strings) {
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = strings[i].intern();
        }
    }

    public static class PropositionDefinitionDisplayNameComparator
    implements Comparator<PropositionDefinition> {
        private final Style style;

        public PropositionDefinitionDisplayNameComparator() {
            this(Style.REGULAR);
        }

        public PropositionDefinitionDisplayNameComparator(Style style) {
            this.style = style;
        }

        @Override
        public int compare(PropositionDefinition k1, PropositionDefinition k2) {
            switch (this.style) {
                case REGULAR: {
                    return k1.getDisplayName().compareTo(k2.getDisplayName());
                }
                case ABBREVIATED: {
                    return k1.getAbbreviatedDisplayName().compareTo(k2.getAbbreviatedDisplayName());
                }
            }
            throw new AssertionError((Object)"should not be reached");
        }

        public static enum Style {
            ABBREVIATED,
            REGULAR;

        }
    }
}

