/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.datastore;

import java.io.IOException;
import org.drools.RuleBase;
import org.drools.StatefulSession;
import org.eurekaclinical.datastore.DataStore;
import org.eurekaclinical.datastore.DataStoreFactory;
import org.eurekaclinical.datastore.bdb.BdbPersistentStoreFactory;
import org.protempa.datastore.DataStores;
import org.protempa.datastore.DroolsWorkingMemoryStore;

public final class WorkingMemoryDataStores
implements DataStores<String, StatefulSession> {
    public static final String DATABASE_NAME = "WorkingMemoryStore";
    private final RuleBase ruleBase;
    private final DataStoreFactory storeFactory;

    public WorkingMemoryDataStores(RuleBase ruleBase, String directory) {
        if (ruleBase == null) {
            throw new IllegalArgumentException("ruleBase cannot be null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null");
        }
        this.ruleBase = ruleBase;
        this.storeFactory = new BdbPersistentStoreFactory(directory);
    }

    @Override
    public DataStore<String, StatefulSession> getDataStore(String name) throws IOException {
        return new DroolsWorkingMemoryStore(this.storeFactory, name, this.ruleBase);
    }

    @Override
    public void close() throws IOException {
        this.storeFactory.close();
    }
}

