/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend;

import org.arp.javautil.serviceloader.SingletonServiceLoader;
import org.protempa.backend.BackendProvider;
import org.protempa.backend.BackendProviderSpecLoaderException;
import org.protempa.backend.BackendSpecLoader;
import org.protempa.backend.asb.AlgorithmSourceBackend;
import org.protempa.backend.dsb.DataSourceBackend;
import org.protempa.backend.ksb.KnowledgeSourceBackend;

public final class BackendProviderManager {
    private static BackendProvider backendProvider;
    private static ClassLoader backendProviderClassLoader;
    private static boolean backendProviderClassLoaderSpecified;

    private BackendProviderManager() {
    }

    public static void setBackendProviderClassLoader(ClassLoader loader) {
        backendProviderClassLoader = loader;
        backendProviderClassLoaderSpecified = true;
    }

    public static ClassLoader getBackendProviderClassLoader() {
        return backendProviderClassLoader;
    }

    public static boolean isBackendProviderClassLoaderSpecified() {
        return backendProviderClassLoaderSpecified;
    }

    public static void setBackendProvider(BackendProvider backendProvider) {
        BackendProviderManager.backendProvider = backendProvider;
    }

    public static BackendProvider getBackendProvider() {
        BackendProviderManager.loadBackendProviderIfNeeded();
        return backendProvider;
    }

    public static BackendSpecLoader<DataSourceBackend> getDataSourceBackendSpecLoader() throws BackendProviderSpecLoaderException {
        BackendProviderManager.loadBackendProviderIfNeeded();
        return backendProvider.getDataSourceBackendSpecLoader();
    }

    public static BackendSpecLoader<KnowledgeSourceBackend> getKnowledgeSourceBackendSpecLoader() throws BackendProviderSpecLoaderException {
        BackendProviderManager.loadBackendProviderIfNeeded();
        return backendProvider.getKnowledgeSourceBackendSpecLoader();
    }

    public static BackendSpecLoader<AlgorithmSourceBackend> getAlgorithmSourceBackendSpecLoader() throws BackendProviderSpecLoaderException {
        BackendProviderManager.loadBackendProviderIfNeeded();
        return backendProvider.getAlgorithmSourceBackendSpecLoader();
    }

    private static void loadBackendProviderIfNeeded() {
        if (backendProvider == null) {
            backendProvider = backendProviderClassLoaderSpecified ? (BackendProvider)SingletonServiceLoader.load(BackendProvider.class, (ClassLoader)backendProviderClassLoader) : (BackendProvider)SingletonServiceLoader.load(BackendProvider.class);
        }
        if (backendProvider == null) {
            throw new IllegalStateException("No backendProvider found by service discovery or set with setBackendProvicer");
        }
    }
}

