/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.Format;
import java.text.NumberFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.AbstractProposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.IntervalFactory;
import org.protempa.proposition.interval.SimpleInterval;
import org.protempa.proposition.value.Granularity;
import org.protempa.proposition.value.Unit;

public abstract class TemporalProposition
extends AbstractProposition {
    private static final long serialVersionUID = 3263217702318065414L;
    private static final ThreadLocal<NumberFormat> numberFormat = new ThreadLocal<NumberFormat>(){

        @Override
        protected NumberFormat initialValue() {
            NumberFormat format = NumberFormat.getInstance();
            format.setGroupingUsed(true);
            return format;
        }
    };
    protected static final IntervalFactory INTERVAL_FACTORY = new IntervalFactory();
    private transient Interval interval;

    TemporalProposition(String id, UniqueId uniqueId) {
        super(id, uniqueId);
        this.interval = INTERVAL_FACTORY.getInstance();
    }

    protected TemporalProposition() {
    }

    public final Interval getInterval() {
        return this.interval;
    }

    public void setInterval(Interval interval) {
        if (interval == null) {
            interval = INTERVAL_FACTORY.getInstance();
        }
        this.interval = interval;
    }

    public final String getStartFormattedLong() {
        Granularity startGran = this.interval.getStartGranularity();
        return this.formatStart(startGran != null ? startGran.getLongFormat() : null);
    }

    public final String getLengthFormattedLong() {
        Unit lengthUnit = this.interval.getLengthUnit();
        return this.formatLength(lengthUnit != null ? lengthUnit.getLongFormat() : null);
    }

    public final String getLengthFormattedMedium() {
        Unit lengthUnit = this.interval.getLengthUnit();
        return this.formatLength(lengthUnit != null ? lengthUnit.getMediumFormat() : null);
    }

    public final String getLengthFormattedShort() {
        Unit lengthUnit = this.interval.getLengthUnit();
        return this.formatLength(lengthUnit != null ? lengthUnit.getShortFormat() : null);
    }

    public final String getFinishFormattedLong() {
        Granularity finishGran = this.interval.getFinishGranularity();
        return this.formatFinish(finishGran != null ? finishGran.getLongFormat() : null);
    }

    public final String getStartFormattedMedium() {
        Granularity startGran = this.interval.getStartGranularity();
        return this.formatStart(startGran != null ? startGran.getMediumFormat() : null);
    }

    public final String getFinishFormattedMedium() {
        Granularity finishGran = this.interval.getFinishGranularity();
        return this.formatFinish(finishGran != null ? finishGran.getMediumFormat() : null);
    }

    public final String getStartFormattedShort() {
        Granularity startGran = this.interval.getStartGranularity();
        return this.formatStart(startGran != null ? startGran.getShortFormat() : null);
    }

    public final String getFinishFormattedShort() {
        Granularity finishGran = this.interval.getFinishGranularity();
        return this.formatFinish(finishGran != null ? finishGran.getShortFormat() : null);
    }

    public final String formatStart(Format format) {
        if (format != null) {
            Long minStart = this.interval.getMinStart();
            if (minStart != null) {
                return format.format(minStart);
            }
            return "Unknown";
        }
        Long minStart = this.interval.getMinStart();
        if (minStart != null) {
            return numberFormat.get().format(minStart);
        }
        return "Unknown";
    }

    public final String formatFinish(Format format) {
        if (format != null) {
            Long minFinish = this.interval.getMinFinish();
            if (minFinish != null) {
                return format.format(minFinish);
            }
            return "Unknown";
        }
        Long minFinish = this.interval.getMinFinish();
        if (minFinish != null) {
            return numberFormat.get().format(minFinish);
        }
        return "Unknown";
    }

    public final String formatLength(Format format) {
        if (format != null) {
            Long minLength = this.interval.getMinLength();
            if (minLength != null) {
                return format.format(minLength);
            }
            return "Unknown";
        }
        Long minLength = this.interval.getMinLength();
        if (minLength != null) {
            return numberFormat.get().format(minLength);
        }
        return "Unknown";
    }

    @Override
    public boolean isEqual(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TemporalProposition)) {
            return false;
        }
        TemporalProposition p = (TemporalProposition)other;
        return super.isEqual(p) && (this.interval == p.interval || this.interval.equals(p.interval));
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)("interval=" + this.interval)).appendSuper(super.toString()).toString();
    }

    protected void writeTemporalProposition(ObjectOutputStream s) throws IOException {
        if (this.interval instanceof SimpleInterval) {
            long start = this.interval.getMinStart();
            long finish = this.interval.getMinFinish();
            Granularity startGran = this.interval.getStartGranularity();
            Granularity finishGran = this.interval.getFinishGranularity();
            if (start == finish && startGran == finishGran) {
                s.writeChar(0);
                s.writeLong(start);
                s.writeObject(startGran);
            } else {
                s.writeChar(1);
                s.writeLong(start);
                s.writeObject(startGran);
                s.writeLong(finish);
                s.writeObject(finishGran);
            }
        } else {
            s.writeChar(2);
            s.writeObject(this.interval.getMinStart());
            s.writeObject(this.interval.getMaxStart());
            s.writeObject(this.interval.getStartGranularity());
            s.writeObject(this.interval.getMinFinish());
            s.writeObject(this.interval.getMaxFinish());
            s.writeObject(this.interval.getFinishGranularity());
        }
    }

    protected void readTemporalProposition(ObjectInputStream s) throws IOException, ClassNotFoundException {
        char mode = s.readChar();
        try {
            switch (mode) {
                case '\u0000': {
                    this.setInterval(INTERVAL_FACTORY.getInstance(s.readLong(), (Granularity)s.readObject()));
                    break;
                }
                case '\u0001': {
                    this.setInterval(INTERVAL_FACTORY.getInstance(s.readLong(), (Granularity)s.readObject(), s.readLong(), (Granularity)s.readObject()));
                    break;
                }
                case '\u0002': {
                    this.setInterval(INTERVAL_FACTORY.getInstance((Long)s.readObject(), (Long)s.readObject(), (Granularity)s.readObject(), (Long)s.readObject(), (Long)s.readObject(), (Granularity)s.readObject()));
                    break;
                }
                default: {
                    throw new InvalidObjectException("Can't restore. Invalid mode: " + mode);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidObjectException("Can't restore: " + iae.getMessage());
        }
    }
}

