/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.AlgorithmSource;
import org.protempa.DataStreamingEvent;
import org.protempa.DoProcessThread;
import org.protempa.ExecutionStrategy;
import org.protempa.KnowledgeSource;
import org.protempa.PropositionDefinitionCache;
import org.protempa.QueueObject;
import org.protempa.StatefulExecutionStrategy;
import org.protempa.StatelessExecutionStrategy;
import org.protempa.proposition.Proposition;
import org.protempa.query.Query;

public class DoRegularProcessThread
extends DoProcessThread<ExecutionStrategy> {
    private static final Logger LOGGER = Logger.getLogger(DoRegularProcessThread.class.getName());
    private final BlockingQueue<DataStreamingEvent<Proposition>> doProcessQueue;
    private final DataStreamingEvent<Proposition> doProcessPoisonPill;
    private final AlgorithmSource algorithmSource;

    DoRegularProcessThread(BlockingQueue<DataStreamingEvent<Proposition>> doProcessQueue, BlockingQueue<QueueObject> hqrQueue, DataStreamingEvent<Proposition> doProcessPoisonPill, QueueObject hqrPoisonPill, Query query, Thread producer, AlgorithmSource algorithmSource, KnowledgeSource knowledgeSource, PropositionDefinitionCache propositionDefinitionCache) {
        super(hqrQueue, hqrPoisonPill, query, producer, knowledgeSource, propositionDefinitionCache, LOGGER);
        this.doProcessQueue = doProcessQueue;
        this.doProcessPoisonPill = doProcessPoisonPill;
        this.algorithmSource = algorithmSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doProcessDataLoop() throws InterruptedException {
        DataStreamingEvent<Proposition> dse;
        int count = 0;
        while (!this.isInterrupted() && (dse = this.doProcessQueue.take()) != this.doProcessPoisonPill) {
            try {
                List<Proposition> data = dse.getData();
                this.doProcessData(dse.getKeyId(), data.iterator(), data.size(), this.getQuery());
                ++count;
            }
            finally {
                this.closeWorkingMemory();
            }
        }
        this.log(Level.INFO, "Processed {0} keys", count);
    }

    @Override
    ExecutionStrategy selectExecutionStrategy() {
        Query query = this.getQuery();
        if (query.getDatabasePath() != null) {
            this.log(Level.FINER, "Chosen stateful execution strategy");
            return new StatefulExecutionStrategy(this.algorithmSource, query);
        }
        this.log(Level.FINER, "Chosen stateless execution strategy");
        return new StatelessExecutionStrategy(this.algorithmSource, query);
    }
}

