/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.arp.javautil.arrays.Arrays;
import org.protempa.AbstractionFinder;
import org.protempa.CloseException;
import org.protempa.DataStreamingEvent;
import org.protempa.DoProcessThread;
import org.protempa.DoRegularProcessThread;
import org.protempa.DoReprocessThread;
import org.protempa.HandleQueryResultThread;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceImplWrapper;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.ProtempaAlreadyClosedException;
import org.protempa.ProtempaUtil;
import org.protempa.QueryException;
import org.protempa.QueueObject;
import org.protempa.RetrieveDataThread;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.dest.Destination;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerCloseException;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.QueryResultsHandlerProcessingException;
import org.protempa.dest.QueryResultsHandlerValidationFailedException;
import org.protempa.proposition.Proposition;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;

final class Executor
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(Executor.class.getName());
    private final Set<String> propIds;
    private final Filter filters;
    private final PropositionDefinition[] propDefs;
    private final KnowledgeSource ks;
    private final Query query;
    private PropositionDefinitionCache propositionDefinitionCache;
    private final AbstractionFinder abstractionFinder;
    private final Destination destination;
    private QueryResultsHandler resultsHandler;
    private boolean failed;
    private final MessageFormat logMessageFormat;
    private HandleQueryResultThread handleQueryResultThread;
    private boolean canceled;
    private QueryException exception;

    Executor(Query query, Destination resultsHandlerFactory, AbstractionFinder abstractionFinder) throws QueryException {
        this.abstractionFinder = abstractionFinder;
        assert (query != null) : "query cannot be null";
        assert (resultsHandlerFactory != null) : "resultsHandlerFactory cannot be null";
        assert (abstractionFinder != null) : "abstractionFinder cannot be null";
        if (abstractionFinder.isClosed()) {
            throw new QueryException(query.getName(), new ProtempaAlreadyClosedException());
        }
        this.propIds = Arrays.asSet((Object[])query.getPropositionIds());
        this.filters = query.getFilters();
        this.propDefs = query.getPropositionDefinitions();
        this.ks = this.propDefs != null && this.propDefs.length > 0 ? new KnowledgeSourceImplWrapper(abstractionFinder.getKnowledgeSource(), this.propDefs) : abstractionFinder.getKnowledgeSource();
        this.query = query;
        this.destination = resultsHandlerFactory;
        this.logMessageFormat = ProtempaUtil.getLogMessageFormat(this.query);
    }

    void init() throws QueryException {
        try {
            this.createQueryResultsHandler();
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, "Propositions to be queried are {0}", StringUtils.join(this.propIds, (String)", "));
            }
            this.extractPropositionDefinitionCache();
            this.startQueryResultsHandler();
        }
        catch (Error | RuntimeException | KnowledgeSourceReadException | QueryResultsHandlerInitException | QueryResultsHandlerProcessingException | QueryResultsHandlerValidationFailedException ex) {
            this.failed = true;
            throw new QueryException(this.query.getName(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Executor executor = this;
        synchronized (executor) {
            if (this.handleQueryResultThread != null) {
                this.handleQueryResultThread.interrupt();
            }
            this.canceled = true;
        }
        this.log(Level.INFO, "Canceled");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void execute() throws QueryException {
        try {
            DoProcessThread doProcessThread;
            RetrieveDataThread retrieveDataThread;
            Executor executor = this;
            synchronized (executor) {
                if (this.canceled) {
                    return;
                }
                this.log(Level.INFO, "Processing data");
                ArrayBlockingQueue<DataStreamingEvent<Proposition>> doProcessQueue = new ArrayBlockingQueue<DataStreamingEvent<Proposition>>(1000);
                QueueObject hqrPoisonPill = new QueueObject();
                ArrayBlockingQueue<QueueObject> hqrQueue = new ArrayBlockingQueue<QueueObject>(1000);
                QueryMode queryMode = this.query.getQueryMode();
                if (Arrays.contains((Object[])QueryMode.etlModes(), (Object)((Object)queryMode))) {
                    DataStreamingEvent<Proposition> doProcessPoisonPill = new DataStreamingEvent<Proposition>("poison", Collections.emptyList());
                    retrieveDataThread = new RetrieveDataThread(doProcessQueue, doProcessPoisonPill, this.query, this.abstractionFinder.getDataSource(), this.propositionDefinitionCache, this.filters, this.resultsHandler);
                    doProcessThread = new DoRegularProcessThread(doProcessQueue, hqrQueue, doProcessPoisonPill, hqrPoisonPill, this.query, retrieveDataThread, this.abstractionFinder.getAlgorithmSource(), this.abstractionFinder.getKnowledgeSource(), this.propositionDefinitionCache);
                } else {
                    retrieveDataThread = null;
                    doProcessThread = new DoReprocessThread(hqrQueue, hqrPoisonPill, this.query, this.abstractionFinder.getAlgorithmSource(), this.abstractionFinder.getKnowledgeSource(), this.propositionDefinitionCache);
                }
                this.handleQueryResultThread = new HandleQueryResultThread(hqrQueue, hqrPoisonPill, doProcessThread, this.query, this.resultsHandler);
                if (retrieveDataThread != null) {
                    retrieveDataThread.start();
                }
                doProcessThread.start();
                this.handleQueryResultThread.start();
            }
            if (retrieveDataThread != null) {
                try {
                    retrieveDataThread.join();
                    for (QueryException e : retrieveDataThread.getExceptions()) {
                        if (this.exception == null) {
                            this.exception = e;
                            continue;
                        }
                        this.exception.addSuppressed(e);
                    }
                    this.log(Level.INFO, "Done retrieving data");
                }
                catch (InterruptedException ex) {
                    this.log(Level.FINER, "Protempa producer thread join interrupted", ex);
                }
            }
            try {
                doProcessThread.join();
                for (QueryException e : doProcessThread.getExceptions()) {
                    if (this.exception == null) {
                        this.exception = e;
                        continue;
                    }
                    this.exception.addSuppressed(e);
                }
                this.log(Level.INFO, "Done processing data");
            }
            catch (InterruptedException ex) {
                this.log(Level.FINER, "Protempa consumer thread join interrupted", ex);
            }
            try {
                this.handleQueryResultThread.join();
                for (QueryException e : this.handleQueryResultThread.getExceptions()) {
                    if (this.exception == null) {
                        this.exception = e;
                        continue;
                    }
                    this.exception.addSuppressed(e);
                }
                this.log(Level.INFO, "Done outputting results");
            }
            catch (InterruptedException ex) {
                this.log(Level.FINER, "Protempa consumer thread join interrupted", ex);
            }
            if (this.exception != null) {
                throw this.exception;
            }
        }
        catch (QueryException ex) {
            this.failed = true;
            throw ex;
        }
    }

    @Override
    public void close() throws CloseException {
        try {
            if (this.resultsHandler != null) {
                if (!this.failed) {
                    this.resultsHandler.finish();
                }
                this.resultsHandler.close();
                this.resultsHandler = null;
            }
        }
        catch (QueryResultsHandlerCloseException | QueryResultsHandlerProcessingException ex) {
            throw new CloseException(ex);
        }
        finally {
            if (this.resultsHandler != null) {
                try {
                    this.resultsHandler.close();
                }
                catch (QueryResultsHandlerCloseException queryResultsHandlerCloseException) {}
            }
        }
    }

    boolean isLoggable(Level level) {
        return LOGGER.isLoggable(level);
    }

    void log(Level level, String msg, Object[] params) {
        if (this.isLoggable(level)) {
            LOGGER.log(level, this.logMessageFormat.format(new Object[]{msg}), params);
        }
    }

    void log(Level level, String msg, Object param) {
        if (this.isLoggable(level)) {
            LOGGER.log(level, this.logMessageFormat.format(new Object[]{msg}), param);
        }
    }

    void log(Level level, String msg, Throwable throwable) {
        if (this.isLoggable(level)) {
            LOGGER.log(level, this.logMessageFormat.format(new Object[]{msg}), throwable);
        }
    }

    void log(Level level, String msg) {
        if (this.isLoggable(level)) {
            LOGGER.log(level, this.logMessageFormat.format(new Object[]{msg}));
        }
    }

    private void extractPropositionDefinitionCache() throws KnowledgeSourceReadException {
        this.propositionDefinitionCache = new PropositionDefinitionCache(this.ks.collectPropDefDescendantsUsingAllNarrower(false, this.propIds.toArray(new String[this.propIds.size()])));
        if (this.isLoggable(Level.FINE)) {
            HashSet<String> allNarrowerDescendantsPropIds = new HashSet<String>();
            for (PropositionDefinition pd : this.propositionDefinitionCache.getAll()) {
                allNarrowerDescendantsPropIds.add(pd.getId());
            }
            this.log(Level.FINE, "Proposition details: {0}", StringUtils.join(allNarrowerDescendantsPropIds, (String)", "));
        }
    }

    private void startQueryResultsHandler() throws QueryResultsHandlerProcessingException {
        this.log(Level.FINE, "Calling query results handler start...");
        this.resultsHandler.start(this.propositionDefinitionCache);
        this.log(Level.FINE, "Query results handler started");
        this.log(Level.FINE, "Query results handler waiting for results...");
    }

    private void createQueryResultsHandler() throws QueryResultsHandlerValidationFailedException, QueryResultsHandlerInitException {
        this.log(Level.FINE, "Initializing query results handler...");
        this.resultsHandler = this.destination.getQueryResultsHandler(this.query, this.abstractionFinder.getDataSource(), this.ks, this.abstractionFinder.getEventListeners());
        this.log(Level.FINE, "Got query results handler {0}", this.resultsHandler.getId());
        this.log(Level.FINE, "Validating query results handler");
        this.resultsHandler.validate();
        this.log(Level.FINE, "Query results handler validated successfully");
    }
}

