/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.Algorithm;
import org.protempa.AlgorithmArguments;
import org.protempa.AlgorithmInitializationException;
import org.protempa.AlgorithmProcessingException;
import org.protempa.LowLevelAbstractionDefinition;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Segment;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;

public class LowLevelAbstractionValueDefinition
implements Serializable {
    private static final long serialVersionUID = 667871001125802717L;
    private Value value = null;
    private final String id;
    private final LowLevelAbstractionDefinition lowLevelAbstractionDefinition;
    private final Map<String, Value> parameterValues;
    private final Map<String, ValueComparator> parameterValueComps;
    private AlgorithmArguments algorithmArguments;

    public LowLevelAbstractionValueDefinition(LowLevelAbstractionDefinition lowLevelAbstractionDefinition, String id) {
        if (lowLevelAbstractionDefinition == null) {
            throw new IllegalArgumentException("A low level abstraction definition must be specified");
        }
        this.lowLevelAbstractionDefinition = lowLevelAbstractionDefinition;
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.id = id.intern();
        this.lowLevelAbstractionDefinition.addValueDefinition(this);
        this.parameterValues = new HashMap<String, Value>();
        this.parameterValueComps = new HashMap<String, ValueComparator>();
    }

    public final void setParameterValue(String str, Value val) {
        this.parameterValues.put(str, val);
        this.algorithmArguments = null;
    }

    public final Value getParameterValue(String str) {
        return this.parameterValues.get(str);
    }

    public final Set<String> getParameters() {
        return this.parameterValues.keySet();
    }

    public final void setParameterComp(String str, ValueComparator comp) {
        this.parameterValueComps.put(str, comp);
        this.algorithmArguments = null;
    }

    public final Set<String> getParameterComps() {
        return this.parameterValueComps.keySet();
    }

    public final ValueComparator getParameterComp(String str) {
        return this.parameterValueComps.get(str);
    }

    public final LowLevelAbstractionDefinition getLowLevelAbstractionDefinition() {
        return this.lowLevelAbstractionDefinition;
    }

    final boolean satisfiedBy(Segment<PrimitiveParameter> segment, Algorithm algorithm) throws AlgorithmInitializationException, AlgorithmProcessingException {
        Value result = null;
        if (algorithm != null) {
            if (this.algorithmArguments == null) {
                this.algorithmArguments = new AlgorithmArguments(algorithm, this);
                algorithm.initialize(this.algorithmArguments);
            }
            result = algorithm.compute(segment, this.algorithmArguments);
        } else {
            result = BooleanValue.TRUE;
        }
        return result != null;
    }

    public final void setValue(Value value) {
        this.value = value;
    }

    public final Value getValue() {
        return this.value;
    }

    public final String getId() {
        return this.id;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

