/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.datastore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eurekaclinical.datastore.DataStore;
import org.eurekaclinical.datastore.DataStoreFactory;
import org.eurekaclinical.datastore.bdb.BdbPersistentStoreFactory;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.WorkingMemoryFactStore;
import org.protempa.datastore.DataStores;

public final class WorkingMemoryDataStores
implements DataStores {
    public static final String DATABASE_NAME = "WorkingMemoryStore";
    private DataStoreFactory storeFactory;
    private Map<String, PropositionDefinitionCache> propositionDefinitionsInStores;
    private PropositionDefinitionCache cache;
    private Path storedPropDefsFile;
    private String databaseName;

    public WorkingMemoryDataStores(Path directory, String name, PropositionDefinitionCache cache) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
        this.propositionDefinitionsInStores = new HashMap<String, PropositionDefinitionCache>();
        this.storeFactory = new BdbPersistentStoreFactory(directory.toString());
        this.storedPropDefsFile = directory.resolve(name + ".stored-propdefs");
        if (Files.exists(this.storedPropDefsFile, new LinkOption[0])) {
            try (ObjectInputStream ois = new ObjectInputStream(Files.newInputStream(this.storedPropDefsFile, new OpenOption[0]));){
                int size = ois.readInt();
                ArrayList<PropositionDefinition> propDefs = new ArrayList<PropositionDefinition>(size);
                for (int i = 0; i < size; ++i) {
                    Object obj = ois.readObject();
                    if (obj == null) {
                        throw new IOException("null object read");
                    }
                    propDefs.add((PropositionDefinition)obj);
                }
                this.propositionDefinitionsInStores.put(name, new PropositionDefinitionCache(propDefs));
                cache.merge(this.propositionDefinitionsInStores.get(name));
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("Error deserializing proposition definitions", ex);
            }
        }
        this.databaseName = name;
        this.cache = cache;
    }

    public PropositionDefinitionCache getPropositionDefinitionsInStores() {
        return this.propositionDefinitionsInStores.get(this.databaseName);
    }

    @Override
    public boolean exists() throws IOException {
        return this.storeFactory.exists(this.databaseName);
    }

    @Override
    public DataStore<String, WorkingMemoryFactStore> getDataStore() throws IOException {
        return this.storeFactory.getInstance(this.databaseName);
    }

    @Override
    public void finish() throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(this.storedPropDefsFile, new OpenOption[0]));){
            Collection<PropositionDefinition> all = this.cache.getAll();
            oos.writeInt(all.size());
            for (PropositionDefinition pd : all) {
                oos.writeObject(pd);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.storeFactory.close();
        this.storeFactory = null;
    }
}

