/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.io.ObjectStreamException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import org.protempa.proposition.value.AbstractTimeUnit;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.ValueUtil;

public class AbsoluteTimeUnit
extends AbstractTimeUnit {
    private static final long serialVersionUID = -6754830065091052862L;
    private static final ResourceBundle resourceBundle = ValueUtil.resourceBundle();
    private static final String[] ABBREV_NAMES = new String[]{resourceBundle.getString("rel_time_field_abbrev_sec"), resourceBundle.getString("rel_time_field_abbrev_min"), resourceBundle.getString("rel_time_field_abbrev_hr"), resourceBundle.getString("rel_time_field_abbrev_day"), resourceBundle.getString("rel_time_field_abbrev_wk"), resourceBundle.getString("rel_time_field_abbrev_month"), resourceBundle.getString("rel_time_field_abbrev_yr")};
    private static final String[] NAMES = new String[]{resourceBundle.getString("rel_time_field_singular_sec"), resourceBundle.getString("rel_time_field_singular_min"), resourceBundle.getString("rel_time_field_singular_hr"), resourceBundle.getString("rel_time_field_singular_day"), resourceBundle.getString("rel_time_field_singular_wk"), resourceBundle.getString("rel_time_field_singular_month"), resourceBundle.getString("rel_time_field_singular_yr")};
    private static final String[] PLURAL_NAMES = new String[]{resourceBundle.getString("rel_time_field_plural_sec"), resourceBundle.getString("rel_time_field_plural_min"), resourceBundle.getString("rel_time_field_plural_hr"), resourceBundle.getString("rel_time_field_plural_day"), resourceBundle.getString("rel_time_field_plural_wk"), resourceBundle.getString("rel_time_field_plural_month"), resourceBundle.getString("rel_time_field_plural_yr")};
    private static final String[] longRelativeTimeFormats = new String[]{resourceBundle.getString("long_rel_time_format_gran_sec"), resourceBundle.getString("long_rel_time_format_gran_min"), resourceBundle.getString("long_rel_time_format_gran_hr"), resourceBundle.getString("long_rel_time_format_gran_day"), resourceBundle.getString("long_rel_time_format_gran_wk"), resourceBundle.getString("long_rel_time_format_gran_month"), resourceBundle.getString("long_rel_time_format_gran_yr")};
    private static final String[] mediumRelativeTimeFormats = new String[]{resourceBundle.getString("med_rel_time_format_gran_sec"), resourceBundle.getString("med_rel_time_format_gran_min"), resourceBundle.getString("med_rel_time_format_gran_hr"), resourceBundle.getString("med_rel_time_format_gran_day"), resourceBundle.getString("med_rel_time_format_gran_wk"), resourceBundle.getString("med_rel_time_format_gran_month"), resourceBundle.getString("med_rel_time_format_gran_yr")};
    private static final String[] shortRelativeTimeFormats = new String[]{resourceBundle.getString("short_rel_time_format_gran_sec"), resourceBundle.getString("short_rel_time_format_gran_min"), resourceBundle.getString("short_rel_time_format_gran_hr"), resourceBundle.getString("short_rel_time_format_gran_day"), resourceBundle.getString("short_rel_time_format_gran_wk"), resourceBundle.getString("short_rel_time_format_gran_month"), resourceBundle.getString("short_rel_time_format_gran_yr")};
    private static final double avgDaysInMonth = 30.4375;
    private static final long millisInSecond = 1000L;
    private static final long millisInMinute = 60000L;
    private static final long millisInHour = 3600000L;
    private static final long millisInDay = 86400000L;
    private static final long millisInWeek = 604800000L;
    private static final long millisInMonth = Math.round(2.6298E9);
    private static final long millisInYear = millisInMonth * 12L;
    private static final int[] CALENDAR_TIME_UNITS = new int[]{13, 12, 11, 5, 4, 2, 1};
    public static final AbsoluteTimeUnit SECOND = new AbsoluteTimeUnit(NAMES[0], PLURAL_NAMES[0], ABBREV_NAMES[0], shortRelativeTimeFormats[0], mediumRelativeTimeFormats[0], longRelativeTimeFormats[0], 1000L, CALENDAR_TIME_UNITS[0], true);
    public static final AbsoluteTimeUnit MINUTE = new AbsoluteTimeUnit(NAMES[1], PLURAL_NAMES[1], ABBREV_NAMES[1], shortRelativeTimeFormats[1], mediumRelativeTimeFormats[1], longRelativeTimeFormats[1], 60000L, CALENDAR_TIME_UNITS[1], true);
    public static final AbsoluteTimeUnit HOUR = new AbsoluteTimeUnit(NAMES[2], PLURAL_NAMES[2], ABBREV_NAMES[2], shortRelativeTimeFormats[2], mediumRelativeTimeFormats[2], longRelativeTimeFormats[2], 3600000L, CALENDAR_TIME_UNITS[2], true);
    public static final AbsoluteTimeUnit DAY = new AbsoluteTimeUnit(NAMES[3], PLURAL_NAMES[3], ABBREV_NAMES[3], shortRelativeTimeFormats[3], mediumRelativeTimeFormats[3], longRelativeTimeFormats[3], 86400000L, CALENDAR_TIME_UNITS[3], false);
    public static final AbsoluteTimeUnit WEEK = new AbsoluteTimeUnit(NAMES[4], PLURAL_NAMES[4], ABBREV_NAMES[4], shortRelativeTimeFormats[4], mediumRelativeTimeFormats[4], longRelativeTimeFormats[4], 604800000L, CALENDAR_TIME_UNITS[4], false);
    public static final AbsoluteTimeUnit MONTH = new AbsoluteTimeUnit(NAMES[5], PLURAL_NAMES[5], ABBREV_NAMES[5], shortRelativeTimeFormats[5], mediumRelativeTimeFormats[5], longRelativeTimeFormats[5], millisInMonth, CALENDAR_TIME_UNITS[5], false);
    public static final AbsoluteTimeUnit YEAR = new AbsoluteTimeUnit(NAMES[6], PLURAL_NAMES[6], ABBREV_NAMES[6], shortRelativeTimeFormats[6], mediumRelativeTimeFormats[6], longRelativeTimeFormats[6], millisInYear, CALENDAR_TIME_UNITS[6], false);
    private static final AbsoluteTimeUnit[] VALUES = new AbsoluteTimeUnit[]{SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, YEAR};
    private static int nextOrdinal = 0;
    private static final Calendar testLeapSecondCal = Calendar.getInstance();
    private static boolean fastDurationCalcsEnabled;
    private final transient Calendar cal;
    private final transient boolean isUsingFastDurationCalculations;
    private int ordinal = nextOrdinal++;

    public static AbsoluteTimeUnit nameToUnit(String name) {
        int pos = AbsoluteTimeUnit.validateName(name);
        if (pos == -1) {
            return null;
        }
        return VALUES[pos];
    }

    private static int validateName(String unitString) {
        int pos = -1;
        for (int i = 0; i < NAMES.length; ++i) {
            if (!NAMES[i].equals(unitString)) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private AbsoluteTimeUnit(String name, String pluralName, String abbreviation, String shortFormat, String mediumFormat, String longFormat, long length, int calUnits, boolean canUseFastDistanceCalcs) {
        super(name, pluralName, abbreviation, shortFormat, mediumFormat, longFormat, length, calUnits);
        this.cal = Calendar.getInstance();
        this.isUsingFastDurationCalculations = fastDurationCalcsEnabled ? canUseFastDistanceCalcs : false;
    }

    boolean isUsingFastDurationCalculations() {
        return this.isUsingFastDurationCalculations;
    }

    private Object readResolve() throws ObjectStreamException {
        return VALUES[this.ordinal];
    }

    public Unit getUnits() {
        return this;
    }

    @Override
    public int compareTo(Unit arg0) {
        AbsoluteTimeUnit rtu = (AbsoluteTimeUnit)arg0;
        return this.ordinal - rtu.ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addToPosition(long position, int duration) {
        if (this.isUsingFastDurationCalculations) {
            return position + (long)duration * this.getLength();
        }
        Calendar calendar = this.cal;
        synchronized (calendar) {
            this.cal.setTimeInMillis(position);
            this.cal.add(this.getCalendarUnits(), duration);
            return this.cal.getTimeInMillis();
        }
    }

    static {
        if (testLeapSecondCal instanceof GregorianCalendar && testLeapSecondCal.getMaximum(13) == 59) {
            fastDurationCalcsEnabled = true;
            ValueUtil.logger().fine("Fast duration calculations enabled");
        } else {
            ValueUtil.logger().fine("Exact duration calulations enabled.");
        }
    }
}

