/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.protempa.Attribute;
import org.protempa.NotRecordedSourceId;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.ReferenceDefinition;
import org.protempa.SourceId;

public abstract class AbstractPropositionDefinition
implements PropositionDefinition {
    private static final long serialVersionUID = -2754387751719003721L;
    private static final PropertyDefinition[] EMPTY_PROPERTIES = new PropertyDefinition[0];
    private static final ReferenceDefinition[] EMPTY_REFERENCES = new ReferenceDefinition[0];
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    protected static final String CHILDREN_PROPERTY = "children";
    private final String id;
    private String propositionId;
    private String displayName;
    private String abbrevDisplayName;
    private String[] inverseIsA;
    protected String[] children;
    private String[] termIds;
    private String description;
    private PropertyDefinition[] propertyDefinitions;
    private ReferenceDefinition[] referenceDefinitions;
    private boolean inDataSource;
    private SourceId sourceId;
    private Date accessed;
    private Date created;
    private Date updated;
    private Date downloaded;
    private String version;
    private Attribute[] attributes;

    AbstractPropositionDefinition(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.propositionId = this.id = id.intern();
        this.children = ArrayUtils.EMPTY_STRING_ARRAY;
        this.inverseIsA = ArrayUtils.EMPTY_STRING_ARRAY;
        this.termIds = ArrayUtils.EMPTY_STRING_ARRAY;
        this.displayName = "";
        this.abbrevDisplayName = "";
        this.description = "";
        this.propertyDefinitions = EMPTY_PROPERTIES;
        this.referenceDefinitions = EMPTY_REFERENCES;
        this.sourceId = NotRecordedSourceId.getInstance();
        this.attributes = EMPTY_ATTRIBUTES;
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final String getPropositionId() {
        return this.propositionId;
    }

    public final void setPropositionId(String propId) {
        this.propositionId = propId == null ? this.id : propId;
    }

    @Override
    public final String getAbbreviatedDisplayName() {
        return this.abbrevDisplayName;
    }

    public final void setAbbreviatedDisplayName(String abbrev) {
        if (abbrev == null) {
            abbrev = "";
        }
        this.abbrevDisplayName = abbrev;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    public final void setDisplayName(String displayName) {
        if (displayName == null) {
            displayName = "";
        }
        this.displayName = displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            description = "";
        }
        this.description = description;
    }

    @Override
    public String[] getInverseIsA() {
        return (String[])this.inverseIsA.clone();
    }

    public void setInverseIsA(String ... inverseIsA) {
        ProtempaUtil.checkArrayForNullElement(inverseIsA, "inverseIsA");
        ProtempaUtil.checkArrayForDuplicates(inverseIsA, "inverseIsA");
        this.inverseIsA = (String[])inverseIsA.clone();
        this.recalculateChildren();
    }

    @Override
    public String[] getChildren() {
        return (String[])this.children.clone();
    }

    @Override
    public final String[] getTermIds() {
        return (String[])this.termIds.clone();
    }

    public final void setTermIds(String ... termIds) {
        ProtempaUtil.checkArrayForNullElement(termIds, "termIds");
        ProtempaUtil.checkArrayForDuplicates(termIds, "termIds");
        this.termIds = (String[])termIds.clone();
    }

    @Override
    public final PropertyDefinition[] getPropertyDefinitions() {
        return (PropertyDefinition[])this.propertyDefinitions.clone();
    }

    @Override
    public final PropertyDefinition propertyDefinition(String id) {
        for (PropertyDefinition propertyDefinition : this.propertyDefinitions) {
            if (!propertyDefinition.getId().equals(id)) continue;
            return propertyDefinition;
        }
        return null;
    }

    public final void setPropertyDefinitions(PropertyDefinition ... propertyDefinitions) {
        ProtempaUtil.checkArrayForNullElement(propertyDefinitions, "propertyDefinitions");
        ProtempaUtil.checkArrayForDuplicates(propertyDefinitions, "propertyDefinitions");
        this.propertyDefinitions = (PropertyDefinition[])propertyDefinitions.clone();
    }

    @Override
    public final ReferenceDefinition[] getReferenceDefinitions() {
        return (ReferenceDefinition[])this.referenceDefinitions.clone();
    }

    @Override
    public final ReferenceDefinition referenceDefinition(String name) {
        for (ReferenceDefinition referenceDefinition : this.referenceDefinitions) {
            if (!referenceDefinition.getId().equals(name)) continue;
            return referenceDefinition;
        }
        return null;
    }

    public final void setReferenceDefinitions(ReferenceDefinition ... referenceDefinitions) {
        ProtempaUtil.checkArrayForNullElement(referenceDefinitions, "referenceDefinitions");
        ProtempaUtil.checkArrayForDuplicates(referenceDefinitions, "referenceDefinitions");
        this.referenceDefinitions = (ReferenceDefinition[])referenceDefinitions.clone();
    }

    @Override
    public boolean getInDataSource() {
        return this.inDataSource;
    }

    public void setInDataSource(boolean inDataSource) {
        this.inDataSource = inDataSource;
    }

    @Override
    public SourceId getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(SourceId sourceId) {
        this.sourceId = sourceId == null ? NotRecordedSourceId.getInstance() : sourceId;
    }

    @Override
    public Date getAccessed() {
        return this.accessed;
    }

    @Override
    public Date getCreated() {
        return this.created;
    }

    @Override
    public Date getUpdated() {
        return this.updated;
    }

    public void setAccessed(Date accessed) {
        this.accessed = accessed;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public Date getDownloaded() {
        return this.downloaded;
    }

    public void setDownloaded(Date downloaded) {
        this.downloaded = downloaded;
    }

    @Override
    public Attribute[] getAttributes() {
        return (Attribute[])this.attributes.clone();
    }

    public void setAttributes(Attribute[] attributes) {
        this.attributes = attributes == null ? EMPTY_ATTRIBUTES : (Attribute[])attributes.clone();
    }

    @Override
    public Attribute attribute(String name) {
        for (Attribute attribute : this.attributes) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public void reset() {
        this.setDisplayName(null);
        this.setAbbreviatedDisplayName(null);
        this.setDescription(null);
        this.setInverseIsA(ArrayUtils.EMPTY_STRING_ARRAY);
        this.setTermIds(ArrayUtils.EMPTY_STRING_ARRAY);
        this.setPropertyDefinitions(new PropertyDefinition[0]);
        this.setReferenceDefinitions(new ReferenceDefinition[0]);
        this.setInDataSource(false);
        this.setAccessed(null);
        this.setCreated(null);
        this.setUpdated(null);
    }

    protected abstract void recalculateChildren();

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this);
    }
}

