/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.arrays.Arrays;
import org.protempa.proposition.Proposition;

public class WorkingMemoryFactStore
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Proposition> propositions;
    private Map<Proposition, Set<Proposition>> forwardDerivations;
    private Map<Proposition, Set<Proposition>> backwardDerivations;
    private Map<String, Integer> instanceNums;

    public List<Proposition> getPropositions() {
        return this.propositions;
    }

    public void setPropositions(List<Proposition> propositions) {
        this.propositions = propositions;
    }

    public Map<Proposition, Set<Proposition>> getForwardDerivations() {
        return this.forwardDerivations;
    }

    public void setForwardDerivations(Map<Proposition, Set<Proposition>> forwardDerivations) {
        this.forwardDerivations = forwardDerivations;
    }

    public Map<Proposition, Set<Proposition>> getBackwardDerivations() {
        return this.backwardDerivations;
    }

    public void setBackwardDerivations(Map<Proposition, Set<Proposition>> backwardDerivations) {
        this.backwardDerivations = backwardDerivations;
    }

    public Map<String, Integer> getInstanceNums() {
        return this.instanceNums;
    }

    public void setInstanceNums(Map<String, Integer> instanceNums) {
        this.instanceNums = instanceNums;
    }

    Collection<Proposition> getAll(String[] propIds) {
        Set pIds = Arrays.asSet((Object[])propIds);
        ArrayList<Proposition> result = new ArrayList<Proposition>();
        if (this.propositions != null) {
            for (Proposition prop : this.propositions) {
                if (!pIds.contains(prop.getId())) continue;
                result.add(prop);
            }
        }
        return result;
    }

    void removeAll(Collection<Proposition> propositions) {
        for (Proposition prop : propositions) {
            this.forwardDerivations.remove(prop);
            this.backwardDerivations.remove(prop);
            for (Collection collection : this.forwardDerivations.values()) {
                collection.remove(prop);
            }
            for (Collection collection : this.backwardDerivations.values()) {
                collection.remove(prop);
            }
            if (this.propositions == null) continue;
            this.propositions.remove(prop);
        }
    }

    Collection<Proposition> removeAll(String[] propIds) {
        Iterator itr;
        Set pIds = Arrays.asSet((Object[])propIds);
        LinkedList queue = new LinkedList(this.forwardDerivations != null ? this.forwardDerivations.keySet() : Collections.emptySet());
        HashSet<String> removed = new HashSet<String>(Arrays.asSet((Object[])propIds));
        ArrayList<Proposition> removedProps = new ArrayList<Proposition>();
        while (!queue.isEmpty()) {
            Proposition prop3 = (Proposition)queue.remove();
            if (prop3 == null || !pIds.contains(prop3.getId())) continue;
            Collection collection = this.forwardDerivations != null ? (Collection)this.forwardDerivations.remove(prop3) : null;
            removed.add(prop3.getId());
            if (collection == null) continue;
            queue.addAll(collection);
        }
        for (Collection collection : this.forwardDerivations.values()) {
            itr = collection.iterator();
            while (itr.hasNext()) {
                Proposition prop2 = (Proposition)itr.next();
                if (!removed.contains(prop2.getId())) continue;
                itr.remove();
            }
        }
        Iterator<Object> itr2 = this.backwardDerivations.keySet().iterator();
        while (itr2.hasNext()) {
            Proposition proposition = itr2.next();
            if (proposition != null && !removed.contains(proposition.getId())) continue;
            itr2.remove();
        }
        for (Collection collection : this.backwardDerivations.values()) {
            itr = collection.iterator();
            while (itr.hasNext()) {
                Proposition prop = (Proposition)itr.next();
                if (prop != null && !removed.contains(prop.getId())) continue;
                itr.remove();
            }
        }
        if (this.propositions != null) {
            Iterator<Proposition> itr3 = this.propositions.iterator();
            while (itr3.hasNext()) {
                Proposition proposition = itr3.next();
                if (proposition != null && !removed.contains(proposition.getId())) continue;
                removedProps.add(proposition);
                itr3.remove();
            }
        }
        return removedProps;
    }
}

