/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.util.Map;
import java.util.Set;
import org.protempa.KnowledgeSource;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.dest.table.AbstractTableColumnSpec;
import org.protempa.dest.table.TableColumnSpecValidationFailedException;
import org.protempa.dest.table.TabularWriter;
import org.protempa.dest.table.TabularWriterException;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.value.NominalValue;

public class ConstantColumnSpec
extends AbstractTableColumnSpec {
    private final NominalValue value;
    private final String heading;

    public ConstantColumnSpec(String heading, String value) {
        if (heading == null) {
            throw new IllegalArgumentException("heading cannot be null");
        }
        this.heading = heading;
        this.value = value != null ? NominalValue.getInstance(value) : null;
    }

    @Override
    public String[] columnNames(KnowledgeSource knowledgeSource) throws KnowledgeSourceReadException {
        return new String[]{this.heading};
    }

    @Override
    public void columnValues(String key, Proposition proposition, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, KnowledgeSourceCache knowledgeSourceCache, TabularWriter writer) throws TabularWriterException {
        writer.writeNominal(this.value);
    }

    @Override
    public void validate(KnowledgeSource knowledgeSource) throws TableColumnSpecValidationFailedException, KnowledgeSourceReadException {
    }

    @Override
    public String[] getInferredPropositionIds(KnowledgeSource knowledgeSource, String[] inPropIds) throws KnowledgeSourceReadException {
        return inPropIds;
    }
}

