/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.arrays.Arrays;
import org.drools.RuleBaseConfiguration;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.base.SalienceInteger;
import org.drools.rule.Collect;
import org.drools.rule.Declaration;
import org.drools.rule.EvalCondition;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.Pattern;
import org.drools.rule.PatternSource;
import org.drools.rule.PredicateConstraint;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.ConflictResolver;
import org.drools.spi.Consequence;
import org.drools.spi.Constraint;
import org.drools.spi.EvalExpression;
import org.drools.spi.ObjectType;
import org.drools.spi.PredicateExpression;
import org.drools.spi.Salience;
import org.drools.spi.Tuple;
import org.protempa.AbstractParameterPredicateExpression;
import org.protempa.AbstractPropositionDefinitionCheckedVisitor;
import org.protempa.AbstractionCombiner;
import org.protempa.Algorithm;
import org.protempa.CollectionSizeExpression;
import org.protempa.CompoundLowLevelAbstractionConsequence;
import org.protempa.CompoundLowLevelAbstractionDefinition;
import org.protempa.ConstantDefinition;
import org.protempa.ContextCombiner;
import org.protempa.ContextDefinition;
import org.protempa.ContextDefinitionInducedByConsequence;
import org.protempa.CycleDetectedException;
import org.protempa.DeletedProposition;
import org.protempa.DerivationsBuilder;
import org.protempa.EventDefinition;
import org.protempa.ExtendedPropositionDefinition;
import org.protempa.HighLevelAbstractionCondition;
import org.protempa.HighLevelAbstractionConsequence;
import org.protempa.HighLevelAbstractionDefinition;
import org.protempa.LowLevelAbstractionConsequence;
import org.protempa.LowLevelAbstractionDefinition;
import org.protempa.PROTEMPAConflictResolver;
import org.protempa.PrimitiveParameterDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionPredicateExpression;
import org.protempa.ProtempaException;
import org.protempa.QueryException;
import org.protempa.RuleBaseInstantiationException;
import org.protempa.SequentialTemporalPatternConsequence;
import org.protempa.SequentialTemporalPatternDefinition;
import org.protempa.SliceConsequence;
import org.protempa.SliceDefinition;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPropositionDefinition;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Context;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.query.Query;

class JBossRuleCreator
extends AbstractPropositionDefinitionCheckedVisitor {
    private static final ClassObjectType PRIM_PARAM_OT = new ClassObjectType(PrimitiveParameter.class);
    private static final ClassObjectType ARRAY_LIST_OT = new ClassObjectType(ArrayList.class);
    private static final ClassObjectType TEMP_PROP_OT = new ClassObjectType(TemporalProposition.class);
    private static final ClassObjectType ABSTRACT_PARAM_OT = new ClassObjectType(AbstractParameter.class);
    private static final ClassObjectType PROP_OT = new ClassObjectType(Proposition.class);
    private static final ClassObjectType CONTEXT_OT = new ClassObjectType(Context.class);
    private static final SalienceInteger TWO_SALIENCE = new SalienceInteger(2);
    private static final SalienceInteger ONE_SALIENCE = new SalienceInteger(1);
    private static final SalienceInteger MINUS_TWO_SALIENCE = new SalienceInteger(-2);
    private static final SalienceInteger MINUS_THREE_SALIENCE = new SalienceInteger(-3);
    private static final AbstractionCombiner ABSTRACTION_COMBINER = new AbstractionCombiner();
    private static final ContextCombiner CONTEXT_COMBINER = new ContextCombiner();
    private static final Logger LOGGER = Logger.getLogger(JBossRuleCreator.class.getName());
    private final Map<LowLevelAbstractionDefinition, Algorithm> algorithms;
    private final List<Rule> rules;
    private final Map<Rule, TemporalPropositionDefinition> ruleToAbstractionDefinition;
    private final DerivationsBuilder derivationsBuilder;
    private final Map<String, PropositionDefinition> cache;
    private final Query query;

    JBossRuleCreator(Map<LowLevelAbstractionDefinition, Algorithm> algorithms, DerivationsBuilder derivationsBuilder, Collection<PropositionDefinition> cache, Query query) {
        assert (cache != null) : "cache cannot be null";
        assert (query != null) : "query cannot be null";
        this.query = query;
        this.algorithms = algorithms;
        this.rules = new ArrayList<Rule>();
        this.ruleToAbstractionDefinition = new HashMap<Rule, TemporalPropositionDefinition>();
        this.derivationsBuilder = derivationsBuilder;
        this.cache = new HashMap<String, PropositionDefinition>();
        for (PropositionDefinition pd : cache) {
            this.cache.put(pd.getId(), pd);
        }
    }

    Map<Rule, TemporalPropositionDefinition> getRuleToTPDMap() {
        return this.ruleToAbstractionDefinition;
    }

    @Override
    public void visit(ContextDefinition def) throws ProtempaException {
        LOGGER.log(Level.FINER, "Creating rule for {0}", def);
        try {
            boolean ruleCreated = false;
            TemporalExtendedPropositionDefinition[] tepds = def.getInducedBy();
            if (tepds.length > 0) {
                Rule inducedByRule = new Rule(def.getId() + "_INDUCED_BY");
                for (int i = 0; i < tepds.length; ++i) {
                    Pattern sourceP = new Pattern(i, (ObjectType)TEMP_PROP_OT);
                    sourceP.addConstraint((Constraint)new PredicateConstraint((PredicateExpression)new GetMatchesPredicateExpression(tepds[i], this)));
                    inducedByRule.addPattern((RuleConditionElement)sourceP);
                }
                inducedByRule.setConsequence((Consequence)new ContextDefinitionInducedByConsequence(def, this.derivationsBuilder));
                inducedByRule.setSalience((Salience)MINUS_THREE_SALIENCE);
                this.rules.add(inducedByRule);
                this.ruleToAbstractionDefinition.put(inducedByRule, def);
                ruleCreated = true;
            }
            if (ruleCreated) {
                CONTEXT_COMBINER.toRules(def, this.rules, this.derivationsBuilder);
            }
        }
        catch (InvalidRuleException e) {
            throw new AssertionError((Object)(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage()));
        }
    }

    @Override
    public void visit(LowLevelAbstractionDefinition def) throws ProtempaException {
        LOGGER.log(Level.FINER, "Creating rule for {0}", def);
        try {
            if (!def.getValueDefinitions().isEmpty()) {
                Rule rule = new Rule(def.getId());
                Pattern sourceP = new Pattern(2, 1, (ObjectType)PRIM_PARAM_OT, "");
                Set<String> abstractedFrom = def.getAbstractedFrom();
                String[] abstractedFromArr = abstractedFrom.toArray(new String[abstractedFrom.size()]);
                Set<String> subtrees = this.collectPropIdDescendantsUsingInverseIsA(abstractedFromArr);
                sourceP.addConstraint((Constraint)new PredicateConstraint((PredicateExpression)new PropositionPredicateExpression(subtrees)));
                Pattern resultP = new Pattern(1, 1, (ObjectType)ARRAY_LIST_OT, "result");
                resultP.setSource((PatternSource)new Collect(sourceP, new Pattern(1, 1, (ObjectType)ARRAY_LIST_OT, "result")));
                resultP.addConstraint((Constraint)new PredicateConstraint((PredicateExpression)new CollectionSizeExpression(1)));
                rule.addPattern((RuleConditionElement)resultP);
                String contextId = def.getContextId();
                if (contextId != null) {
                    Pattern sourceP2 = new Pattern(4, 1, (ObjectType)CONTEXT_OT, "context");
                    sourceP2.addConstraint((Constraint)new PredicateConstraint((PredicateExpression)new PropositionPredicateExpression(contextId)));
                    Pattern resultP2 = new Pattern(3, 1, (ObjectType)ARRAY_LIST_OT, "result2");
                    resultP2.setSource((PatternSource)new Collect(sourceP2, new Pattern(3, 1, (ObjectType)ARRAY_LIST_OT, "result")));
                    resultP2.addConstraint((Constraint)new PredicateConstraint((PredicateExpression)new CollectionSizeExpression(1)));
                    rule.addPattern((RuleConditionElement)resultP2);
                }
                Algorithm algo = this.algorithms.get(def);
                rule.setConsequence((Consequence)new LowLevelAbstractionConsequence(def, algo, this.derivationsBuilder));
                rule.setSalience((Salience)TWO_SALIENCE);
                this.ruleToAbstractionDefinition.put(rule, def);
                this.rules.add(rule);
            }
        }
        catch (InvalidRuleException e) {
            throw new AssertionError((Object)(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage()));
        }
    }

    @Override
    public void visit(CompoundLowLevelAbstractionDefinition def) throws ProtempaException {
        LOGGER.log(Level.FINER, "Creating rule for {0}", def);
        try {
            if (!def.getLowLevelAbstractionIds().isEmpty()) {
                Rule rule = new Rule(def.getId());
                Pattern sourceP = new Pattern(2, 1, (ObjectType)ABSTRACT_PARAM_OT, "");
                Set<String> abstractedFrom = def.getAbstractedFrom();
                String[] abstractedFromArr = abstractedFrom.toArray(new String[abstractedFrom.size()]);
                Set<String> subtrees = this.collectPropIdDescendantsUsingInverseIsA(abstractedFromArr);
                sourceP.addConstraint((Constraint)new PredicateConstraint((PredicateExpression)new AbstractParameterPredicateExpression(subtrees, def.getContextId())));
                Pattern resultP = new Pattern(1, 1, (ObjectType)ARRAY_LIST_OT, "result");
                resultP.setSource((PatternSource)new Collect(sourceP, new Pattern(1, 1, (ObjectType)ARRAY_LIST_OT, "result")));
                resultP.addConstraint((Constraint)new PredicateConstraint((PredicateExpression)new CollectionSizeExpression(1)));
                rule.addPattern((RuleConditionElement)resultP);
                rule.setConsequence((Consequence)new CompoundLowLevelAbstractionConsequence(def, this.derivationsBuilder));
                rule.setSalience((Salience)ONE_SALIENCE);
                this.ruleToAbstractionDefinition.put(rule, def);
                this.rules.add(rule);
                ABSTRACTION_COMBINER.toRules(def, this.rules, this.derivationsBuilder);
            }
        }
        catch (InvalidRuleException e) {
            throw new AssertionError((Object)(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage()));
        }
    }

    @Override
    public void visit(HighLevelAbstractionDefinition def) throws ProtempaException {
        LOGGER.log(Level.FINER, "Creating rule for {0}", def);
        try {
            Set<ExtendedPropositionDefinition> epdsC = def.getExtendedPropositionDefinitions();
            if (!epdsC.isEmpty()) {
                Rule rule = new Rule(def.getId());
                rule.setSalience((Salience)TWO_SALIENCE);
                ExtendedPropositionDefinition[] epds = epdsC.toArray(new ExtendedPropositionDefinition[epdsC.size()]);
                for (int i = 0; i < epds.length; ++i) {
                    Pattern p = new Pattern(i, (ObjectType)PROP_OT);
                    GetMatchesPredicateExpression matchesPredicateExpression = new GetMatchesPredicateExpression(epds[i], this);
                    PredicateConstraint c = new PredicateConstraint((PredicateExpression)matchesPredicateExpression);
                    p.addConstraint((Constraint)c);
                    rule.addPattern((RuleConditionElement)p);
                }
                rule.addPattern((RuleConditionElement)new EvalCondition((EvalExpression)new HighLevelAbstractionCondition(def, epds), null));
                rule.setConsequence((Consequence)new HighLevelAbstractionConsequence(def, epds, this.derivationsBuilder));
                this.ruleToAbstractionDefinition.put(rule, def);
                this.rules.add(rule);
                ABSTRACTION_COMBINER.toRules(def, this.rules, this.derivationsBuilder);
            }
        }
        catch (InvalidRuleException e) {
            throw new AssertionError((Object)(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage()));
        }
    }

    @Override
    public void visit(SliceDefinition def) throws ProtempaException {
        LOGGER.log(Level.FINER, "Creating rule for {0}", def);
        try {
            Set<TemporalExtendedPropositionDefinition> epdsC = def.getTemporalExtendedPropositionDefinitions();
            if (!epdsC.isEmpty()) {
                TemporalExtendedPropositionDefinition[] epds = epdsC.toArray(new TemporalExtendedPropositionDefinition[epdsC.size()]);
                Rule rule = new Rule("SLICE_" + def.getId());
                Pattern sourceP = new Pattern(2, 1, (ObjectType)TEMP_PROP_OT, "");
                for (int i = 0; i < epds.length; ++i) {
                    GetMatchesPredicateExpression matchesPredicateExpression = new GetMatchesPredicateExpression(epds[i], this);
                    PredicateConstraint c = new PredicateConstraint((PredicateExpression)matchesPredicateExpression);
                    sourceP.addConstraint((Constraint)c);
                }
                Pattern resultP = new Pattern(1, 1, (ObjectType)ARRAY_LIST_OT, "result");
                resultP.setSource((PatternSource)new Collect(sourceP, new Pattern(1, 1, (ObjectType)ARRAY_LIST_OT, "result")));
                int minInd = def.getMinIndex();
                int maxInd = def.getMaxIndex();
                int len = maxInd < 0 ? Math.abs(minInd) : maxInd;
                resultP.addConstraint((Constraint)new PredicateConstraint((PredicateExpression)new CollectionSizeExpression(len)));
                rule.addPattern((RuleConditionElement)resultP);
                rule.setConsequence((Consequence)new SliceConsequence(def, this.derivationsBuilder));
                rule.setSalience((Salience)MINUS_TWO_SALIENCE);
                this.ruleToAbstractionDefinition.put(rule, def);
                this.rules.add(rule);
            }
        }
        catch (InvalidRuleException e) {
            throw new AssertionError((Object)(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage()));
        }
    }

    @Override
    public void visit(SequentialTemporalPatternDefinition def) throws ProtempaException {
        LOGGER.log(Level.FINER, "Creating rule for {0}", def);
        try {
            TemporalExtendedPropositionDefinition lhs = def.getFirstTemporalExtendedPropositionDefinition();
            if (lhs != null) {
                Rule rule = new Rule("SEQ_TP_" + def.getId());
                Pattern sourceP = new Pattern(2, (ObjectType)TEMP_PROP_OT);
                GetMatchesPredicateExpression matchesPredicateExpression = new GetMatchesPredicateExpression(lhs, this);
                sourceP.addConstraint((Constraint)new PredicateConstraint((PredicateExpression)matchesPredicateExpression));
                SequentialTemporalPatternDefinition.SubsequentTemporalExtendedPropositionDefinition[] relatedTemporalExtendedPropositionDefinitions = def.getSubsequentTemporalExtendedPropositionDefinitions();
                for (int i = 0; i < relatedTemporalExtendedPropositionDefinitions.length; ++i) {
                    SequentialTemporalPatternDefinition.SubsequentTemporalExtendedPropositionDefinition rtepd = relatedTemporalExtendedPropositionDefinitions[i];
                    GetMatchesPredicateExpression matchesPredicateExpression1 = new GetMatchesPredicateExpression(rtepd.getRelatedTemporalExtendedPropositionDefinition(), this);
                    PredicateConstraint c = new PredicateConstraint((PredicateExpression)matchesPredicateExpression1);
                    sourceP.addConstraint((Constraint)c);
                }
                Pattern resultP = new Pattern(1, 1, (ObjectType)ARRAY_LIST_OT, "result");
                resultP.setSource((PatternSource)new Collect(sourceP, new Pattern(1, 1, (ObjectType)ARRAY_LIST_OT, "result")));
                resultP.addConstraint((Constraint)new PredicateConstraint((PredicateExpression)new CollectionSizeExpression(1)));
                rule.addPattern((RuleConditionElement)resultP);
                rule.setConsequence((Consequence)new SequentialTemporalPatternConsequence(def, this.derivationsBuilder));
                rule.setSalience((Salience)MINUS_TWO_SALIENCE);
                this.ruleToAbstractionDefinition.put(rule, def);
                this.rules.add(rule);
                ABSTRACTION_COMBINER.toRules(def, this.rules, this.derivationsBuilder);
            }
        }
        catch (InvalidRuleException e) {
            throw new AssertionError((Object)(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage()));
        }
    }

    @Override
    public void visit(EventDefinition def) {
    }

    @Override
    public void visit(ConstantDefinition def) {
    }

    @Override
    public void visit(PrimitiveParameterDefinition def) {
    }

    List<Rule> getRules() {
        ArrayList<Rule> rulesToReturn = new ArrayList<Rule>(this.rules);
        new DeletedProposition().toRules(rulesToReturn, this.derivationsBuilder);
        return rulesToReturn;
    }

    RuleBaseConfiguration getRuleBaseConfiguration() throws RuleBaseInstantiationException {
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setShadowProxy(false);
        try {
            config.setConflictResolver((ConflictResolver)new PROTEMPAConflictResolver(this.cache.values(), this.getRuleToTPDMap()));
        }
        catch (CycleDetectedException ex) {
            throw new RuleBaseInstantiationException("Problem creating data processing rules", ex);
        }
        config.setAssertBehaviour(RuleBaseConfiguration.AssertBehaviour.EQUALITY);
        return config;
    }

    private Set<String> collectPropIdDescendantsUsingInverseIsA(String ... propIds) throws QueryException {
        String propId;
        HashSet<String> result = new HashSet<String>();
        LinkedList queue = new LinkedList();
        Arrays.addAll(queue, (Object[][])new String[][]{propIds});
        while ((propId = (String)queue.poll()) != null) {
            PropositionDefinition pd;
            if (!result.add(propId) || (pd = this.cache.get(propId)) == null) continue;
            String[] children = pd.getInverseIsA();
            Arrays.addAll(queue, (Object[][])new String[][]{children});
        }
        return result;
    }

    private static final class GetMatchesPredicateExpression
    implements PredicateExpression {
        private static final long serialVersionUID = -6225160728904051528L;
        private final ExtendedPropositionDefinition epd;
        private final Set<String> subtrees;

        private GetMatchesPredicateExpression(ExtendedPropositionDefinition epd, JBossRuleCreator creator) throws ProtempaException {
            assert (epd != null) : "epd cannot be null";
            this.epd = epd;
            this.subtrees = creator.collectPropIdDescendantsUsingInverseIsA(new String[]{epd.getPropositionId()});
        }

        public boolean evaluate(Object arg0, Tuple arg1, Declaration[] arg2, Declaration[] arg3, WorkingMemory arg4, Object context) throws Exception {
            return this.epd.getMatches((Proposition)arg0, this.subtrees);
        }

        public Object createContext() {
            return null;
        }
    }
}

