/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.arp.javautil.collections.Iterators;
import org.drools.StatelessSession;
import org.drools.StatelessSessionResult;
import org.drools.event.WorkingMemoryEventListener;
import org.protempa.AbstractExecutionStrategy;
import org.protempa.AlgorithmSource;
import org.protempa.DeletedWorkingMemoryEventListener;
import org.protempa.ExecutionStrategyInitializationException;
import org.protempa.JBossRuleCreator;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaException;
import org.protempa.ValidateAlgorithmCheckedVisitor;
import org.protempa.proposition.Proposition;
import org.protempa.query.Query;

class StatelessExecutionStrategy
extends AbstractExecutionStrategy {
    private StatelessSession statelessSession;
    private final DeletedWorkingMemoryEventListener workingMemoryEventListener = new DeletedWorkingMemoryEventListener();

    StatelessExecutionStrategy(AlgorithmSource algorithmSource, Query query) {
        super(algorithmSource, query);
    }

    @Override
    public void initialize(Collection<? extends PropositionDefinition> cache) throws ExecutionStrategyInitializationException {
        super.initialize(cache);
        this.statelessSession = this.getRuleBase().newStatelessSession();
    }

    @Override
    public Iterator<Proposition> execute(String keyId, Iterator<? extends Proposition> props) {
        this.statelessSession.setGlobal("keyId", (Object)keyId);
        this.statelessSession.addEventListener((WorkingMemoryEventListener)this.workingMemoryEventListener);
        StatelessSessionResult result = this.statelessSession.executeWithResults(Iterators.asCollection(props));
        this.statelessSession.removeEventListener((WorkingMemoryEventListener)this.workingMemoryEventListener);
        List<Proposition> propsToDelete = this.workingMemoryEventListener.getPropsToDelete();
        this.workingMemoryEventListener.clear();
        return new IteratorChain(result.iterateObjects(), propsToDelete.iterator());
    }

    @Override
    public void closeCurrentWorkingMemory() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected JBossRuleCreator newRuleCreator() throws ExecutionStrategyInitializationException {
        ValidateAlgorithmCheckedVisitor visitor = new ValidateAlgorithmCheckedVisitor(this.getAlgorithmSource());
        Collection<PropositionDefinition> propDefs = this.getCache();
        try {
            visitor.visit(propDefs);
        }
        catch (ProtempaException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
        JBossRuleCreator ruleCreator = new JBossRuleCreator(visitor.getAlgorithms(), this.getDerivationsBuilder(), propDefs, this.getQuery());
        try {
            ruleCreator.visit(propDefs);
        }
        catch (ProtempaException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
        return ruleCreator;
    }
}

