/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.protempa.DerivationsBuilder;
import org.protempa.proposition.Proposition;

public abstract class AbstractCombinerConsequence<P extends Proposition>
implements Consequence {
    private static final Logger LOGGER = Logger.getLogger(AbstractCombinerConsequence.class.getName());
    private final DerivationsBuilder derivationsBuilder;

    AbstractCombinerConsequence(DerivationsBuilder derivationsBuilder) {
        this.derivationsBuilder = derivationsBuilder;
    }

    public void evaluate(KnowledgeHelper kh, WorkingMemory wm) throws Exception {
        InternalFactHandle a1f = kh.getTuple().get(0);
        Proposition a1 = (Proposition)wm.getObject((FactHandle)a1f);
        InternalFactHandle a2f = kh.getTuple().get(1);
        Proposition a2 = (Proposition)wm.getObject((FactHandle)a2f);
        Proposition result = this.newCombinedFact(a1, a2, wm);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Created {0} from {1} and {2}", new Object[]{result, a1, a2});
        }
        kh.retract((FactHandle)a1f);
        kh.retract((FactHandle)a2f);
        kh.insertLogical((Object)result);
        Set<Proposition> a1PropBackward = this.derivationsBuilder.propositionRetractedBackward(a1);
        Set<Proposition> a2PropBackward = this.derivationsBuilder.propositionRetractedBackward(a2);
        for (Proposition prop : a1PropBackward) {
            this.derivationsBuilder.propositionReplaceForward(prop, a1, result);
            this.derivationsBuilder.propositionAssertedBackward(prop, result);
        }
        for (Proposition prop : a2PropBackward) {
            this.derivationsBuilder.propositionReplaceForward(prop, a2, result);
            this.derivationsBuilder.propositionAssertedBackward(prop, result);
        }
        LOGGER.log(Level.FINER, "Asserted derived proposition {0}", result);
    }

    protected abstract P newCombinedFact(P var1, P var2, WorkingMemory var3);
}

