/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.Collection;
import org.drools.RuleBase;
import org.protempa.AlgorithmSource;
import org.protempa.DerivationsBuilder;
import org.protempa.ExecutionStrategy;
import org.protempa.ExecutionStrategyInitializationException;
import org.protempa.JBossRuleBaseFactory;
import org.protempa.JBossRuleCreator;
import org.protempa.PropositionDefinition;
import org.protempa.RuleBaseInstantiationException;
import org.protempa.query.Query;

abstract class AbstractExecutionStrategy
implements ExecutionStrategy {
    private final AlgorithmSource algorithmSource;
    private final DerivationsBuilder derivationsBuilder;
    private Collection<PropositionDefinition> cache;
    private final Query query;
    private RuleBase ruleBase;

    AbstractExecutionStrategy(AlgorithmSource algorithmSource, Query query) {
        this.algorithmSource = algorithmSource;
        this.derivationsBuilder = new DerivationsBuilder();
        this.query = query;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public DerivationsBuilder getDerivationsBuilder() {
        return this.derivationsBuilder;
    }

    protected final AlgorithmSource getAlgorithmSource() {
        return this.algorithmSource;
    }

    protected Collection<PropositionDefinition> getCache() {
        return this.cache;
    }

    @Override
    public void initialize(Collection<? extends PropositionDefinition> cache) throws ExecutionStrategyInitializationException {
        if (cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
        this.cache = new ArrayList<PropositionDefinition>(cache);
        this.createRuleBase();
    }

    protected RuleBase getRuleBase() {
        return this.ruleBase;
    }

    private void createRuleBase() throws ExecutionStrategyInitializationException {
        JBossRuleCreator ruleCreator = this.newRuleCreator();
        try {
            this.ruleBase = new JBossRuleBaseFactory(ruleCreator).newInstance();
        }
        catch (RuleBaseInstantiationException ex) {
            throw new ExecutionStrategyInitializationException(ex);
        }
    }

    protected abstract JBossRuleCreator newRuleCreator() throws ExecutionStrategyInitializationException;
}

