/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.collections.Collections;
import org.protempa.proposition.Proposition;

final class DerivationsBuilder
implements Serializable {
    private static final long serialVersionUID = -2064122362760283390L;
    private Map<Proposition, Set<Proposition>> forwardDerivations;
    private Map<Proposition, Set<Proposition>> backwardDerivations;

    DerivationsBuilder() {
        this.reset();
    }

    void reset() {
        this.forwardDerivations = new HashMap<Proposition, Set<Proposition>>();
        this.backwardDerivations = new HashMap<Proposition, Set<Proposition>>();
    }

    void reset(Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations) {
        this.forwardDerivations = forwardDerivations != null ? forwardDerivations : new HashMap<Proposition, Set<Proposition>>();
        this.backwardDerivations = backwardDerivations != null ? backwardDerivations : new HashMap<Proposition, Set<Proposition>>();
    }

    Map<Proposition, Set<Proposition>> getForwardDerivations() {
        return this.forwardDerivations;
    }

    Map<Proposition, Set<Proposition>> getBackwardDerivations() {
        return this.backwardDerivations;
    }

    Set<? extends Proposition> propositionRetractedForward(Proposition proposition) {
        return this.forwardDerivations.remove(proposition);
    }

    void propositionReplaceForward(Proposition prop, Proposition oldProp, Proposition newProp) {
        Collection props = this.forwardDerivations.get(prop);
        props.remove(oldProp);
        props.add(newProp);
    }

    void propositionReplaceBackward(Proposition prop, Proposition oldProp, Proposition newProp) {
        Collection props = this.backwardDerivations.get(prop);
        props.remove(oldProp);
        props.add(newProp);
    }

    Set<Proposition> propositionRetractedBackward(Proposition proposition) {
        return this.backwardDerivations.remove(proposition);
    }

    void propositionAsserted(Proposition oldProposition, Proposition newProposition) {
        assert (oldProposition != null) : "old proposition cannot be null";
        assert (newProposition != null) : "new proposition cannot be null";
        Collections.putSet(this.forwardDerivations, (Object)oldProposition, (Object)newProposition);
        Collections.putSet(this.backwardDerivations, (Object)newProposition, (Object)oldProposition);
    }

    void propositionAssertedBackward(Proposition oldProposition, Proposition newProposition) {
        assert (oldProposition != null) : "old proposition cannot be null";
        assert (newProposition != null) : "new proposition cannot be null";
        Collections.putSet(this.backwardDerivations, (Object)newProposition, (Object)oldProposition);
    }
}

