/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.AbstractThread;
import org.protempa.QueryException;
import org.protempa.QueueObject;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerProcessingException;
import org.protempa.query.Query;

class HandleQueryResultThread
extends AbstractThread {
    private static final Logger LOGGER = Logger.getLogger(HandleQueryResultThread.class.getName());
    private final BlockingQueue<QueueObject> queue;
    private final Thread producerThread;
    private final QueueObject poisonPill;
    private final List<QueryException> exceptions;
    private final QueryResultsHandler queryResultsHandler;

    HandleQueryResultThread(BlockingQueue<QueueObject> queue, QueueObject poisonPill, Thread producerThread, Query query, QueryResultsHandler queryResultsHandler) {
        super(query, LOGGER, "protempa.executor.HandleQueryResultThread");
        this.queue = queue;
        this.producerThread = producerThread;
        this.poisonPill = poisonPill;
        this.exceptions = new ArrayList<QueryException>();
        this.queryResultsHandler = queryResultsHandler;
    }

    public List<QueryException> getExceptions() {
        return this.exceptions;
    }

    @Override
    public void run() {
        this.log(Level.FINER, "Start handle query results thread");
        Query query = this.getQuery();
        try {
            QueueObject qo;
            while ((qo = this.queue.take()) != this.poisonPill) {
                this.log(Level.FINER, "Handling some results");
                try {
                    this.queryResultsHandler.handleQueryResult(qo.keyId, qo.propositions, qo.forwardDerivations, qo.backwardDerivations, qo.refs);
                }
                catch (QueryResultsHandlerProcessingException ex) {
                    this.log(Level.FINER, "Handle query results threw QueryResultsHandlerProcessingException", ex);
                    this.exceptions.add(new QueryException(query.getName(), ex));
                    this.producerThread.interrupt();
                    break;
                }
                catch (Error | RuntimeException t) {
                    this.log(Level.FINER, "Handle query results threw exception", t);
                    this.exceptions.add(new QueryException(query.getName(), new QueryResultsHandlerProcessingException(t)));
                    this.producerThread.interrupt();
                    break;
                }
                this.log(Level.FINER, "Results passed to query result handler");
            }
        }
        catch (InterruptedException ex) {
            this.log(Level.FINER, "Handle query results thread interrupted", ex);
            this.producerThread.interrupt();
        }
        this.log(Level.FINER, "End handle query results thread");
    }
}

