/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.arp.javautil.collections.Collections;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.protempa.DerivationsBuilder;
import org.protempa.PropositionCopier;
import org.protempa.proposition.Proposition;

class InverseIsAConsequence
implements Consequence {
    private static final long serialVersionUID = 6157152982863451759L;
    private final Map<String, List<PropositionCopier>> copiersMap;

    InverseIsAConsequence(Map<String, List<String>> inverseIsAPropIdMap, DerivationsBuilder listener) {
        assert (inverseIsAPropIdMap != null) : "inverseIsAPropIdMap cannot be null";
        assert (listener != null) : "listener cannot be null";
        this.copiersMap = new HashMap<String, List<PropositionCopier>>();
        for (Map.Entry<String, List<String>> me : inverseIsAPropIdMap.entrySet()) {
            List<String> targetPropIds = me.getValue();
            ArrayList<PropositionCopier> pcs = new ArrayList<PropositionCopier>(targetPropIds.size());
            for (String targetPropId : targetPropIds) {
                pcs.add(new PropositionCopier(targetPropId, listener));
            }
            Collections.putListMult(this.copiersMap, (Object)me.getKey(), pcs);
        }
    }

    public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) {
        Proposition prop = (Proposition)workingMemory.getObject((FactHandle)knowledgeHelper.getTuple().get(0));
        List<PropositionCopier> copiers = this.copiersMap.get(prop.getId());
        assert (copiers != null) : "copiers should never be null";
        for (PropositionCopier copier : copiers) {
            copier.grab(knowledgeHelper);
            prop.accept(copier);
            copier.release();
        }
    }
}

