/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import org.drools.WorkingMemory;
import org.protempa.AbstractParameterFactory;
import org.protempa.Algorithm;
import org.protempa.AlgorithmInitializationException;
import org.protempa.AlgorithmProcessingException;
import org.protempa.DerivationsBuilder;
import org.protempa.GapFunction;
import org.protempa.HorizontalTemporalInference;
import org.protempa.JBossRulesDerivedLocalUniqueIdValuesProvider;
import org.protempa.LowLevelAbstractionDefinition;
import org.protempa.LowLevelAbstractionValueDefinition;
import org.protempa.ObjectAsserter;
import org.protempa.PatternFinderUser;
import org.protempa.PropositionDefinition;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.ProviderBasedUniqueIdFactory;
import org.protempa.proposition.Segment;
import org.protempa.proposition.Sequence;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.Unit;

public final class LowLevelAbstractionFinder {
    private static final HorizontalTemporalInference HTI = new HorizontalTemporalInference();

    private LowLevelAbstractionFinder() {
    }

    private static Segment<PrimitiveParameter> firstSegment(PatternFinderUser def, Sequence<PrimitiveParameter> sequence, Algorithm algorithm, int maxPatternLength) {
        int size = sequence.size();
        int minPatternLength = LowLevelAbstractionFinder.minPatternLength(algorithm, def);
        if (size > 0 && size >= minPatternLength) {
            int y;
            int x = 0;
            int n = y = minPatternLength < 1 ? size - 1 : minPatternLength - 1;
            if (x <= y) {
                return LowLevelAbstractionFinder.resetSegmentHelper(def, sequence, x, y, new Segment<PrimitiveParameter>(sequence, x, y), algorithm, maxPatternLength);
            }
        }
        return null;
    }

    private static Segment<PrimitiveParameter> nextSegmentAfterMatch(PatternFinderUser def, Segment<PrimitiveParameter> seg, Algorithm algorithm, int minPatternLength, int maxPatternLength) {
        int myCurrentColumn;
        if (seg == null) {
            return null;
        }
        int x = seg.getFirstIndex();
        int y = seg.getLastIndex();
        Segment<PrimitiveParameter> nextSeg = null;
        int arg = def.getMaxOverlapping();
        nextSeg = arg > 0 ? ((myCurrentColumn = y - (arg + 1)) - 1 > x ? LowLevelAbstractionFinder.resetSegment(def, seg, myCurrentColumn, LowLevelAbstractionFinder.getYIndex(def, myCurrentColumn, seg), algorithm, minPatternLength, maxPatternLength) : LowLevelAbstractionFinder.resetSegment(def, seg, LowLevelAbstractionFinder.getXIndex(def, x, seg), LowLevelAbstractionFinder.getYIndex(def, y + 1, seg), algorithm, minPatternLength, maxPatternLength)) : LowLevelAbstractionFinder.resetSegment(def, seg, LowLevelAbstractionFinder.getXIndex(def, x, seg), LowLevelAbstractionFinder.getYIndex(def, y + 1, seg), algorithm, minPatternLength, maxPatternLength);
        return nextSeg;
    }

    private static Segment<PrimitiveParameter> resetSegment(PatternFinderUser def, Segment<PrimitiveParameter> seg, int x, int y, Algorithm algorithm, int minPatternLength, int maxPatternLength) {
        if (minPatternLength < 1) {
            return null;
        }
        y = Math.max(y, x + minPatternLength - 1);
        Sequence<PrimitiveParameter> seq = seg.getSequence();
        seg = seg.resetState(seq, x, y);
        return LowLevelAbstractionFinder.resetSegmentHelper(def, seq, x, y, seg, algorithm, maxPatternLength);
    }

    private static int maxPatternLength(Algorithm algorithm, PatternFinderUser def) {
        switch (def.getSlidingWindowWidthMode()) {
            case RANGE: {
                return def.getMaximumNumberOfValues();
            }
            case ALL: {
                return Integer.MAX_VALUE;
            }
        }
        return algorithm.getMaximumNumberOfValues();
    }

    private static int minPatternLength(Algorithm algorithm, PatternFinderUser def) {
        switch (def.getSlidingWindowWidthMode()) {
            case RANGE: {
                return def.getMinimumNumberOfValues();
            }
            case ALL: {
                return -1;
            }
        }
        return algorithm.getMinimumNumberOfValues();
    }

    private static Segment<PrimitiveParameter> resetSegmentHelper(PatternFinderUser def, Sequence<PrimitiveParameter> sequence, int x, int y, Segment<PrimitiveParameter> seg, Algorithm algorithm, int maxPatternLength) {
        int yMinusXPlusOne;
        Interval segIval = null;
        if (seg != null) {
            segIval = seg.getInterval();
            yMinusXPlusOne = y - x + 1;
        } else {
            yMinusXPlusOne = 0;
        }
        int minDur = def.getMinimumDuration();
        Unit minDurUnits = def.getMinimumDurationUnits();
        Integer maxDur = def.getMaximumDuration();
        Unit maxDurUnits = def.getMaximumDurationUnits();
        while (segIval != null && segIval.isLengthLessThan(minDur, minDurUnits)) {
            if ((seg = ++yMinusXPlusOne > maxPatternLength ? null : seg.resetState(sequence, x, ++y)) != null) {
                segIval = seg.getInterval();
                continue;
            }
            segIval = null;
        }
        if (seg != null && segIval != null && (maxDur != null && segIval.isLengthGreaterThan(maxDur, maxDurUnits) || yMinusXPlusOne > maxPatternLength)) {
            seg = null;
        }
        return seg;
    }

    private static int getXIndex(PatternFinderUser def, int x, Segment<PrimitiveParameter> lastMatch) {
        int skipStart = def.getSkipStart();
        if (lastMatch != null && skipStart > 0) {
            return Math.max(x, lastMatch.getFirstIndex() + skipStart);
        }
        if (lastMatch != null && def.getSkip() > 0) {
            return Math.max(x, lastMatch.getLastIndex() + def.getSkip());
        }
        return x;
    }

    private static int getYIndex(PatternFinderUser def, int y, Segment<PrimitiveParameter> lastMatch) {
        int skipEnd = def.getSkipEnd();
        if (lastMatch != null && skipEnd > 0) {
            return Math.max(y, lastMatch.getLastIndex() + skipEnd);
        }
        if (lastMatch != null && def.getSkip() > 0) {
            return Math.max(y, lastMatch.getLastIndex() + def.getSkip());
        }
        return y;
    }

    private static int advanceRowSearchDirectives(Algorithm algorithm, Segment<PrimitiveParameter> seg, Segment<PrimitiveParameter> lastMatch) {
        if (algorithm != null && lastMatch != null && seg.getFirstIndex() == lastMatch.getFirstIndex() && algorithm.getAdvanceRowSkipEnd() >= 0) {
            return lastMatch.getLastIndex() + algorithm.getAdvanceRowSkipEnd() - 1;
        }
        return seg.getFirstIndex();
    }

    private static Segment<PrimitiveParameter> advanceRow(PatternFinderUser def, Segment<PrimitiveParameter> seg, Segment<PrimitiveParameter> lastMatch, Algorithm algorithm, int minPatternLength, int maxPatternLength) {
        if (seg == null || minPatternLength < 1) {
            return null;
        }
        int x = LowLevelAbstractionFinder.advanceRowSearchDirectives(algorithm, seg, lastMatch);
        int seqSizeMinus1 = seg.getSequence().size() - 1;
        Segment<PrimitiveParameter> nextSeg = null;
        while (nextSeg == null && x < seqSizeMinus1) {
            nextSeg = LowLevelAbstractionFinder.resetSegment(def, seg, LowLevelAbstractionFinder.getXIndex(def, ++x, lastMatch), LowLevelAbstractionFinder.getYIndex(def, x, lastMatch), algorithm, minPatternLength, maxPatternLength);
        }
        return nextSeg;
    }

    static void process(Sequence<PrimitiveParameter> seq, LowLevelAbstractionDefinition def, Algorithm algorithm, ObjectAsserter objAsserter, DerivationsBuilder derivationsBuilder, WorkingMemory workingMemory) throws AlgorithmInitializationException, AlgorithmProcessingException {
        if (def == null || seq == null) {
            return;
        }
        int minPatternLength = LowLevelAbstractionFinder.minPatternLength(algorithm, def);
        int maxPatternLength = LowLevelAbstractionFinder.maxPatternLength(algorithm, def);
        Segment<PrimitiveParameter> seg = LowLevelAbstractionFinder.firstSegment(def, seq, algorithm, maxPatternLength);
        String id = def.getPropositionId();
        JBossRulesDerivedLocalUniqueIdValuesProvider provider = new JBossRulesDerivedLocalUniqueIdValuesProvider(workingMemory, id);
        ProviderBasedUniqueIdFactory factory = new ProviderBasedUniqueIdFactory(provider);
        GapFunction gf = def.getGapFunction();
        if (seg != null) {
            Segment<PrimitiveParameter> lastSeg = null;
            LowLevelAbstractionValueDefinition prevFoundValue = null;
            LowLevelAbstractionValueDefinition foundValue = null;
            do {
                if ((foundValue = def.satisfiedBy(seg, algorithm)) == null) continue;
                Segment<PrimitiveParameter> nextSeg = null;
                do {
                    if (lastSeg != null && foundValue.equals(prevFoundValue) && (HTI.execute((PropositionDefinition)def, lastSeg, seg) || gf.execute(lastSeg, seg))) {
                        lastSeg.resetState(seq, Math.min(lastSeg.getFirstIndex(), seg.getFirstIndex()), Math.max(lastSeg.getLastIndex(), seg.getLastIndex()));
                    } else {
                        if (lastSeg != null) {
                            AbstractParameter proposition = AbstractParameterFactory.getFromAbstraction(id, factory.getInstance(), lastSeg, null, prevFoundValue.getValue(), null, null, def.getContextId());
                            objAsserter.assertObject(proposition);
                            for (Proposition proposition2 : lastSeg) {
                                derivationsBuilder.propositionAsserted(proposition2, proposition);
                            }
                        }
                        lastSeg = new Segment<PrimitiveParameter>(seg);
                    }
                    prevFoundValue = foundValue;
                } while ((nextSeg = LowLevelAbstractionFinder.nextSegmentAfterMatch(def, seg, algorithm, minPatternLength, maxPatternLength)) != null && (foundValue = def.satisfiedBy(nextSeg, algorithm)) != null);
            } while (LowLevelAbstractionFinder.advanceRow(def, seg, lastSeg, algorithm, minPatternLength, maxPatternLength) != null);
            if (lastSeg != null) {
                AbstractParameter proposition = AbstractParameterFactory.getFromAbstraction(id, factory.getInstance(), lastSeg, null, prevFoundValue.getValue(), null, null, def.getContextId());
                objAsserter.assertObject(proposition);
                for (Proposition proposition3 : lastSeg) {
                    derivationsBuilder.propositionAsserted(proposition3, proposition);
                }
                lastSeg = null;
            }
        }
    }
}

