/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.Attribute;
import org.protempa.proposition.value.ValueType;

public final class PropertyDefinition
implements Serializable {
    private static final long serialVersionUID = 5258018980150529695L;
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private final String id;
    private final String displayName;
    private final ValueType valueType;
    private final String valueSetId;
    private final String declaringPropId;
    private final String propId;
    private Attribute[] attributes;
    private Map<String, Attribute> attributeMap;

    public PropertyDefinition(String propId, String id, String displayName, ValueType valueType, String valueSetId, String declaringPropId) {
        this(propId, id, displayName, valueType, valueSetId, declaringPropId, null);
    }

    public PropertyDefinition(String propId, String id, String displayName, ValueType valueType, String valueSetId, String declaringPropId, Attribute[] attributes) {
        if (propId == null) {
            throw new IllegalArgumentException("propId cannot be null");
        }
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        if (valueType == null) {
            throw new IllegalArgumentException("valueType cannot be null");
        }
        if (declaringPropId == null) {
            throw new IllegalArgumentException("declaringPropId cannot be null");
        }
        this.id = id.intern();
        this.displayName = displayName != null ? displayName.intern() : this.id;
        this.propId = propId;
        this.valueType = valueType;
        this.valueSetId = valueSetId;
        this.declaringPropId = declaringPropId;
        this.attributes = attributes == null ? EMPTY_ATTRIBUTES : (Attribute[])attributes.clone();
        this.attributeMap = new HashMap<String, Attribute>();
        for (Attribute attribute : this.attributes) {
            this.attributeMap.put(attribute.getName(), attribute);
        }
    }

    public String getPropId() {
        return this.propId;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public String getValueSetId() {
        return this.valueSetId;
    }

    public String getDeclaringPropId() {
        return this.declaringPropId;
    }

    public boolean isInherited() {
        return !this.propId.equals(this.declaringPropId);
    }

    public Attribute[] getAttributes() {
        return (Attribute[])this.attributes.clone();
    }

    public Attribute getAttribute(String name) {
        return this.attributeMap.get(name);
    }

    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

