/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.PropertyDefinition;
import org.protempa.proposition.value.ValueType;

public final class PropertyDefinitionBuilder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String displayName;
    private ValueType valueType;
    private String valueSetId;
    private String declaringPropId;
    private String propId;

    public PropertyDefinitionBuilder() {
    }

    public PropertyDefinitionBuilder(PropertyDefinition propertyDefinition) {
        if (propertyDefinition != null) {
            this.id = propertyDefinition.getId();
            this.displayName = propertyDefinition.getDisplayName();
            this.valueType = propertyDefinition.getValueType();
            this.valueSetId = propertyDefinition.getValueSetId();
            this.declaringPropId = propertyDefinition.getDeclaringPropId();
            this.propId = propertyDefinition.getPropId();
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    public String getValueSetId() {
        return this.valueSetId;
    }

    public void setValueSetId(String valueSetId) {
        this.valueSetId = valueSetId;
    }

    public String getDeclaringPropId() {
        return this.declaringPropId;
    }

    public void setDeclaringPropId(String declaringPropId) {
        this.declaringPropId = declaringPropId;
    }

    public String getPropId() {
        return this.propId;
    }

    public void setPropId(String propId) {
        this.propId = propId;
    }

    public PropertyDefinition build() {
        return new PropertyDefinition(this.propId, this.id, this.displayName, this.valueType, this.valueSetId, this.declaringPropId);
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.id);
        hash = 83 * hash + Objects.hashCode(this.displayName);
        hash = 83 * hash + Objects.hashCode((Object)this.valueType);
        hash = 83 * hash + Objects.hashCode(this.valueSetId);
        hash = 83 * hash + Objects.hashCode(this.declaringPropId);
        hash = 83 * hash + Objects.hashCode(this.propId);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyDefinitionBuilder other = (PropertyDefinitionBuilder)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        if (!Objects.equals(this.displayName, other.displayName)) {
            return false;
        }
        if (this.valueType != other.valueType) {
            return false;
        }
        if (!Objects.equals(this.valueSetId, other.valueSetId)) {
            return false;
        }
        if (!Objects.equals(this.declaringPropId, other.declaringPropId)) {
            return false;
        }
        return Objects.equals(this.propId, other.propId);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

