/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.List;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamer;
import org.protempa.DataStreamingEventIterator;
import org.protempa.PropositionDataStreamerProcessor;
import org.protempa.RefDataStreamerProcessor;
import org.protempa.UniqueIdPair;
import org.protempa.proposition.Proposition;

final class ReferenceLinkerPropositionDataStreamerProcessor
extends PropositionDataStreamerProcessor
implements AutoCloseable {
    private final DataStreamer refsStreamer;
    private final RefDataStreamerProcessor refsProcessor;
    private final List<? extends DataStreamingEventIterator<UniqueIdPair>> refItrs;

    ReferenceLinkerPropositionDataStreamerProcessor(List<? extends DataStreamingEventIterator<UniqueIdPair>> refItrs) {
        assert (refItrs != null) : "refIrs cannot be null";
        this.refsStreamer = new DataStreamer();
        this.refsProcessor = new RefDataStreamerProcessor();
        this.refItrs = refItrs;
    }

    @Override
    protected void fireKeyCompleted(String keyId, List<Proposition> data) throws DataSourceReadException {
        this.refsProcessor.setPropositions(data);
        this.refsProcessor.setKeyId(keyId);
        this.refsStreamer.doStream(this.refsProcessor, this.refItrs);
        this.refsProcessor.clear();
        super.fireKeyCompleted(keyId, data);
    }

    @Override
    public void close() {
        super.close();
        this.refsStreamer.close();
    }
}

