/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.GapFunction;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.interval.Relation;
import org.protempa.proposition.value.Unit;

public final class SimpleGapFunction
extends GapFunction {
    private static final long serialVersionUID = -6154012083447646091L;
    private static final Integer ZERO = 0;
    private Integer maximumGap;
    private Unit maximumGapUnits;
    private Relation relation;

    public SimpleGapFunction() {
        this(null, null);
    }

    public SimpleGapFunction(Integer maximumGap, Unit maximumGapUnit) {
        if (maximumGap != null && maximumGap.compareTo(ZERO) < 0) {
            throw new IllegalArgumentException("maximumGap must be null or >= 0");
        }
        this.maximumGapUnits = maximumGapUnit;
        this.maximumGap = maximumGap;
        this.initRelation();
    }

    @Override
    public boolean execute(Interval lhs, Interval rhs) {
        if (this.relation == null) {
            return false;
        }
        return this.relation.hasRelation(lhs, rhs);
    }

    public Integer getMaximumGap() {
        return this.maximumGap;
    }

    public Unit getMaximumGapUnit() {
        return this.maximumGapUnits;
    }

    public void setMaximumGap(Integer maximumGap) {
        if (maximumGap != null && maximumGap.compareTo(ZERO) < 0) {
            throw new IllegalArgumentException("maximumGap must be null or >= 0");
        }
        this.maximumGap = maximumGap;
        this.initRelation();
    }

    public void setMaximumGapUnit(Unit unit) {
        this.maximumGapUnits = unit;
        this.initRelation();
    }

    private void initRelation() {
        this.relation = ZERO.equals(this.maximumGap) ? null : new Relation(null, null, null, null, null, null, null, null, 0, this.maximumGapUnits, this.maximumGap, this.maximumGapUnits, null, null, null, null);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("maximumGap", (Object)this.maximumGap).append("maximumGapUnits", (Object)this.maximumGapUnits).toString();
    }
}

