/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend;

import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.BackendProvider;
import org.protempa.backend.BackendProviderManager;
import org.protempa.backend.BackendProviderSpecLoaderException;
import org.protempa.backend.BackendSpec;
import org.protempa.backend.BackendSpecLoader;
import org.protempa.backend.BackendSpecNotFoundException;
import org.protempa.backend.Configurations;
import org.protempa.backend.asb.AlgorithmSourceBackend;
import org.protempa.backend.dsb.DataSourceBackend;
import org.protempa.backend.ksb.KnowledgeSourceBackend;

public abstract class AbstractConfigurations
implements Configurations {
    private final BackendProvider backendProvider;

    protected AbstractConfigurations(BackendProvider backendProvider) {
        this.backendProvider = backendProvider != null ? backendProvider : BackendProviderManager.getBackendProvider();
        if (this.backendProvider == null) {
            throw new AssertionError((Object)"No backend provider available!");
        }
    }

    public BackendProvider getBackendProvider() {
        return this.backendProvider;
    }

    @Override
    public BackendInstanceSpec<AlgorithmSourceBackend> newAlgorithmSourceBackendSection(String id) throws BackendSpecNotFoundException, BackendProviderSpecLoaderException {
        BackendSpecLoader<AlgorithmSourceBackend> loader = this.backendProvider.getAlgorithmSourceBackendSpecLoader();
        BackendSpec<AlgorithmSourceBackend> backendSpec = loader.loadSpec(id);
        return backendSpec.newBackendInstanceSpec();
    }

    @Override
    public BackendInstanceSpec<DataSourceBackend> newDataSourceBackendSection(String id) throws BackendSpecNotFoundException, BackendProviderSpecLoaderException {
        BackendSpecLoader<DataSourceBackend> loader = this.backendProvider.getDataSourceBackendSpecLoader();
        BackendSpec<DataSourceBackend> backendSpec = loader.loadSpec(id);
        return backendSpec.newBackendInstanceSpec();
    }

    @Override
    public BackendInstanceSpec<KnowledgeSourceBackend> newKnowledgeSourceBackendSection(String id) throws BackendSpecNotFoundException, BackendProviderSpecLoaderException {
        BackendSpecLoader<KnowledgeSourceBackend> loader = this.backendProvider.getKnowledgeSourceBackendSpecLoader();
        BackendSpec<KnowledgeSourceBackend> backendSpec = loader.loadSpec(id);
        return backendSpec.newBackendInstanceSpec();
    }
}

