/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.asb.java;

import org.protempa.AbstractAlgorithm;
import org.protempa.AlgorithmArguments;
import org.protempa.AlgorithmParameter;
import org.protempa.Algorithms;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Segment;
import org.protempa.proposition.TemporalParameter;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueType;

public final class StateAlgorithm
extends AbstractAlgorithm {
    private static final long serialVersionUID = 1254880729946491923L;

    public StateAlgorithm(Algorithms algorithms, String id) {
        super(algorithms, id);
        this.setParameters(new AlgorithmParameter[]{new AlgorithmParameter("maxThreshold", new ValueComparator[]{ValueComparator.LESS_THAN, ValueComparator.LESS_THAN_OR_EQUAL_TO, ValueComparator.EQUAL_TO}, ValueType.NUMERICALVALUE), new AlgorithmParameter("minThreshold", new ValueComparator[]{ValueComparator.GREATER_THAN, ValueComparator.GREATER_THAN_OR_EQUAL_TO, ValueComparator.EQUAL_TO}, ValueType.NUMERICALVALUE)});
        this.setMinimumNumberOfValues(1);
        this.setMaximumNumberOfValues(1);
    }

    @Override
    public Value compute(Segment<PrimitiveParameter> segment, AlgorithmArguments args) {
        Value minThreshold = args.value("minThreshold");
        ValueComparator minComparator = args.valueComp("minThreshold");
        Value maxThreshold = args.value("maxThreshold");
        ValueComparator maxComparator = args.valueComp("maxThreshold");
        if (minThreshold != null && minComparator != null || maxThreshold != null && maxComparator != null) {
            int n = segment.size();
            for (int i = 0; i < n; ++i) {
                TemporalParameter param = (TemporalParameter)segment.get(i);
                Value val = param.getValue();
                if (val != null && (minComparator == null || minComparator.compare(val, minThreshold)) && (maxComparator == null || maxComparator.compare(val, maxThreshold))) continue;
                return null;
            }
        }
        return BooleanValue.TRUE;
    }
}

