/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.ksb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.arp.javautil.arrays.Arrays;
import org.arp.javautil.collections.Collections;
import org.protempa.AbstractionDefinition;
import org.protempa.ContextDefinition;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.TemporalExtendedPropositionDefinition;
import org.protempa.TemporalPropositionDefinition;
import org.protempa.backend.BackendInitializationException;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.ksb.AbstractKnowledgeSourceBackend;

public final class SimpleKnowledgeSourceBackend
extends AbstractKnowledgeSourceBackend {
    private Map<String, PropositionDefinition> propDefsMap = new HashMap<String, PropositionDefinition>();
    private Map<String, AbstractionDefinition> abstractionDefsMap = new HashMap<String, AbstractionDefinition>();
    private Map<String, TemporalPropositionDefinition> tempPropDefsMap;
    private Map<String, ContextDefinition> contextDefsMap;
    private final Map<String, List<String>> isAMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> abstractedIntoMap = new HashMap<String, List<String>>();
    private final Map<String, List<String>> inducesMap;
    private final Map<String, List<String>> subContextOfMap;

    public SimpleKnowledgeSourceBackend() {
        this.contextDefsMap = new HashMap<String, ContextDefinition>();
        this.inducesMap = new HashMap<String, List<String>>();
        this.subContextOfMap = new HashMap<String, List<String>>();
        this.tempPropDefsMap = new HashMap<String, TemporalPropositionDefinition>();
    }

    public SimpleKnowledgeSourceBackend(PropositionDefinition ... propDefs) {
        this();
        for (PropositionDefinition propDef : propDefs) {
            String propId = propDef.getId();
            this.propDefsMap.put(propId, propDef);
            if (propDef instanceof AbstractionDefinition) {
                AbstractionDefinition ad = (AbstractionDefinition)propDef;
                this.abstractionDefsMap.put(ad.getId(), ad);
                for (String abstractedFromPropId : ad.getAbstractedFrom()) {
                    Collections.putList(this.abstractedIntoMap, (Object)abstractedFromPropId, (Object)propId);
                }
            }
            if (propDef instanceof TemporalPropositionDefinition) {
                TemporalPropositionDefinition tpd = (TemporalPropositionDefinition)propDef;
                this.tempPropDefsMap.put(tpd.getId(), tpd);
            }
            if (propDef instanceof ContextDefinition) {
                ContextDefinition cd = (ContextDefinition)propDef;
                for (TemporalExtendedPropositionDefinition tepd : cd.getInducedBy()) {
                    Collections.putList(this.inducesMap, (Object)tepd.getPropositionId(), (Object)propId);
                }
                for (String tempPropId : cd.getSubContexts()) {
                    Collections.putList(this.subContextOfMap, (Object)tempPropId, (Object)propId);
                }
                this.contextDefsMap.put(cd.getId(), cd);
            }
            for (String inverseIsAPropId : propDef.getInverseIsA()) {
                Collections.putList(this.isAMap, (Object)inverseIsAPropId, (Object)propId);
            }
        }
    }

    @Override
    public void initialize(BackendInstanceSpec config) throws BackendInitializationException {
        super.initialize(config);
    }

    @Override
    public void fireKnowledgeSourceBackendUpdated() {
        super.fireKnowledgeSourceBackendUpdated();
    }

    @Override
    public String getDisplayName() {
        return "Simple Knowledge Source Backend";
    }

    @Override
    public PropositionDefinition readPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return this.propDefsMap.get(id);
    }

    @Override
    public List<PropositionDefinition> readPropositionDefinitions(String[] ids) throws KnowledgeSourceReadException {
        ArrayList<PropositionDefinition> result = new ArrayList<PropositionDefinition>();
        for (String id : ids) {
            PropositionDefinition ad = this.propDefsMap.get(id);
            if (ad == null) {
                throw new KnowledgeSourceReadException("No proposition definition with id " + id);
            }
            result.add(ad);
        }
        return result;
    }

    @Override
    public AbstractionDefinition readAbstractionDefinition(String id) throws KnowledgeSourceReadException {
        return this.abstractionDefsMap.get(id);
    }

    @Override
    public List<AbstractionDefinition> readAbstractionDefinitions(String[] ids) throws KnowledgeSourceReadException {
        ArrayList<AbstractionDefinition> result = new ArrayList<AbstractionDefinition>();
        for (String id : ids) {
            AbstractionDefinition ad = this.abstractionDefsMap.get(id);
            if (ad == null) {
                throw new KnowledgeSourceReadException("No abstraction definition with id " + id);
            }
            result.add(ad);
        }
        return result;
    }

    @Override
    public String[] readAbstractedInto(String propId) {
        List<String> propIds = this.abstractedIntoMap.get(propId);
        if (propIds == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return propIds.toArray(new String[propIds.size()]);
    }

    @Override
    public String[] readIsA(String propId) {
        List<String> propIds = this.isAMap.get(propId);
        if (propIds == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return propIds.toArray(new String[propIds.size()]);
    }

    @Override
    public ContextDefinition readContextDefinition(String id) throws KnowledgeSourceReadException {
        return this.contextDefsMap.get(id);
    }

    @Override
    public List<ContextDefinition> readContextDefinitions(String[] ids) throws KnowledgeSourceReadException {
        ArrayList<ContextDefinition> result = new ArrayList<ContextDefinition>();
        for (String id : ids) {
            ContextDefinition ad = this.contextDefsMap.get(id);
            if (ad == null) {
                throw new KnowledgeSourceReadException("No context definition with id " + id);
            }
            result.add(ad);
        }
        return result;
    }

    @Override
    public TemporalPropositionDefinition readTemporalPropositionDefinition(String id) throws KnowledgeSourceReadException {
        return this.tempPropDefsMap.get(id);
    }

    @Override
    public List<TemporalPropositionDefinition> readTemporalPropositionDefinitions(String[] ids) throws KnowledgeSourceReadException {
        ArrayList<TemporalPropositionDefinition> result = new ArrayList<TemporalPropositionDefinition>();
        for (String id : ids) {
            TemporalPropositionDefinition ad = this.tempPropDefsMap.get(id);
            if (ad == null) {
                throw new KnowledgeSourceReadException("No temporal proposition definition with id " + id);
            }
            result.add(ad);
        }
        return result;
    }

    @Override
    public String[] readInduces(String propId) throws KnowledgeSourceReadException {
        List<String> propIds = this.inducesMap.get(propId);
        if (propIds == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return propIds.toArray(new String[propIds.size()]);
    }

    @Override
    public String[] readSubContextOfs(String propId) throws KnowledgeSourceReadException {
        List<String> propIds = this.subContextOfMap.get(propId);
        if (propIds == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return propIds.toArray(new String[propIds.size()]);
    }

    @Override
    public Set<String> getKnowledgeSourceSearchResults(String searchKey) throws KnowledgeSourceReadException {
        return null;
    }

    @Override
    public Collection<String> collectPropIdDescendantsUsingAllNarrower(boolean inDataSourceOnly, String[] propIds) {
        return this.collectSubtreePropositionIdsInt(propIds, true, inDataSourceOnly);
    }

    @Override
    public Collection<String> collectPropIdDescendantsUsingInverseIsA(String[] propIds) {
        return this.collectSubtreePropositionIdsInt(propIds, false, false);
    }

    private Collection<String> collectSubtreePropositionIdsInt(String[] propIds, boolean narrower, boolean inDataSource) {
        HashSet<String> result = new HashSet<String>(Arrays.asSet((Object[])propIds));
        LinkedList<String> queue = new LinkedList<String>();
        queue.addAll(result);
        while (!queue.isEmpty()) {
            String propId = (String)queue.poll();
            PropositionDefinition pd = this.propDefsMap.get(propId);
            if (!inDataSource || pd.getInDataSource()) {
                result.add(propId);
            }
            if (narrower) {
                Arrays.addAll(queue, (Object[][])new String[][]{pd.getChildren()});
                continue;
            }
            Arrays.addAll(queue, (Object[][])new String[][]{pd.getInverseIsA()});
        }
        return result;
    }

    @Override
    public Collection<PropositionDefinition> collectPropDefDescendantsUsingAllNarrower(boolean inDataSourceOnly, String[] propIds) {
        return this.collectSubtreePropositionDefinitionsInt(propIds, true, inDataSourceOnly);
    }

    @Override
    public Collection<PropositionDefinition> collectPropDefDescendantsUsingInverseIsA(String[] propIds) {
        return this.collectSubtreePropositionDefinitionsInt(propIds, false, false);
    }

    private Collection<PropositionDefinition> collectSubtreePropositionDefinitionsInt(String[] propIds, boolean narrower, boolean inDataSource) {
        ProtempaUtil.checkArray(propIds, "propDefs");
        HashSet<PropositionDefinition> propResult = new HashSet<PropositionDefinition>();
        LinkedList<String> queue = new LinkedList<String>();
        for (String pd : propIds) {
            queue.add(pd);
        }
        while (!queue.isEmpty()) {
            String propId = (String)queue.poll();
            PropositionDefinition pd = this.propDefsMap.get(propId);
            if (!inDataSource || pd.getInDataSource()) {
                propResult.add(pd);
            }
            if (narrower) {
                Arrays.addAll(queue, (Object[][])new String[][]{pd.getChildren()});
                continue;
            }
            Arrays.addAll(queue, (Object[][])new String[][]{pd.getInverseIsA()});
        }
        return propResult;
    }
}

