/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.datastore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.eurekaclinical.datastore.DataStore;
import org.eurekaclinical.datastore.DataStoreFactory;
import org.eurekaclinical.datastore.bdb.BdbPersistentStoreFactory;
import org.protempa.PropositionDefinition;
import org.protempa.WorkingMemoryFactStore;
import org.protempa.datastore.DataStores;

public final class WorkingMemoryDataStores
implements DataStores {
    public static final String DATABASE_NAME = "WorkingMemoryStore";
    private final DataStoreFactory storeFactory;
    private Collection<PropositionDefinition> storedPropositionDefinitions;

    public WorkingMemoryDataStores(String directory, Collection<? extends PropositionDefinition> cache) throws IOException {
        Throwable throwable;
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null");
        }
        if (cache == null) {
            throw new IllegalArgumentException("cache cannot be null");
        }
        this.storeFactory = new BdbPersistentStoreFactory(directory);
        this.storedPropositionDefinitions = new ArrayList<PropositionDefinition>();
        File file = new File(directory, "stored-propdefs");
        if (file.exists()) {
            try {
                throwable = null;
                try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(file));){
                    this.storedPropositionDefinitions = (Collection)ois.readObject();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (ClassNotFoundException ex) {
                throw new IOException("Error deserializing proposition definitions", ex);
            }
        }
        throwable = null;
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(file));){
            oos.writeObject(cache);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public Collection<PropositionDefinition> getStoredPropositionDefinitions() {
        return this.storedPropositionDefinitions;
    }

    @Override
    public boolean exists(String dbname) throws IOException {
        return this.storeFactory.exists(dbname);
    }

    @Override
    public DataStore<String, WorkingMemoryFactStore> getDataStore(String name) throws IOException {
        return this.storeFactory.getInstance(name);
    }

    @Override
    public void close() throws IOException {
        this.storeFactory.close();
    }
}

