/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.keyloader;

import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.protempa.DataSource;
import org.protempa.KnowledgeSource;
import org.protempa.ProtempaEventListener;
import org.protempa.dest.AbstractDestination;
import org.protempa.dest.QueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.keyloader.Criteria;
import org.protempa.dest.keyloader.KeyLoaderQueryResultsHandler;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;

public class KeyLoaderDestination
extends AbstractDestination {
    private final Criteria criteria;
    private final String id;
    private final String displayName;

    public KeyLoaderDestination(Criteria criteria) {
        this(null, criteria);
    }

    public KeyLoaderDestination(String id, Criteria criteria) {
        this(id, null, criteria);
    }

    public KeyLoaderDestination(String id, String displayName, Criteria criteria) {
        this.criteria = criteria;
        this.id = id;
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : super.getDisplayName();
    }

    @Override
    public String getId() {
        return this.id != null ? this.id : super.getId();
    }

    @Override
    public QueryResultsHandler getQueryResultsHandler(Query query, DataSource dataSource, KnowledgeSource knowledgeSource, List<? extends ProtempaEventListener> eventListeners) throws QueryResultsHandlerInitException {
        if (query.getQueryMode() == QueryMode.UPDATE) {
            throw new QueryResultsHandlerInitException("Update mode not supported");
        }
        return new KeyLoaderQueryResultsHandler(dataSource, knowledgeSource, this.criteria, this.id, this.displayName);
    }

    @Override
    public String[] getSupportedPropositionIds(DataSource dataSource, KnowledgeSource knowledgeSource) {
        if (this.criteria != null) {
            return this.criteria.getPropositionIdsSpecified();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

