/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.keyloader;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.protempa.DataSource;
import org.protempa.DataSourceWriteException;
import org.protempa.KnowledgeSource;
import org.protempa.PropositionDefinition;
import org.protempa.dest.AbstractQueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerProcessingException;
import org.protempa.dest.keyloader.Criteria;
import org.protempa.dest.keyloader.CriteriaEvaluateException;
import org.protempa.dest.keyloader.CriteriaInitException;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;

public class KeyLoaderQueryResultsHandler
extends AbstractQueryResultsHandler {
    private final DataSource dataSource;
    private final Criteria criteria;
    private final KnowledgeSource knowledgeSource;
    private final int batchSize = 1000;
    private final String id;
    private final String displayName;
    private int i;
    private Set<String> keyIds;

    KeyLoaderQueryResultsHandler(DataSource dataSource, KnowledgeSource knowledgeSource, Criteria criteria, String id, String displayName) {
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource cannot be null");
        }
        if (knowledgeSource == null) {
            throw new IllegalArgumentException("dataSource cannot be null");
        }
        this.dataSource = dataSource;
        this.knowledgeSource = knowledgeSource;
        this.criteria = criteria;
        this.id = id;
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : super.getDisplayName();
    }

    @Override
    public String getId() {
        return this.id != null ? this.id : super.getId();
    }

    @Override
    public void start(Collection<PropositionDefinition> cache) throws QueryResultsHandlerProcessingException {
        try {
            this.dataSource.deleteAllKeys();
        }
        catch (DataSourceWriteException ex) {
            throw new QueryResultsHandlerProcessingException("Could not delete keys", ex);
        }
        try {
            this.criteria.init(this.knowledgeSource);
        }
        catch (CriteriaInitException ex) {
            throw new QueryResultsHandlerProcessingException("Error setting up query results handler", ex);
        }
        this.i = 0;
        this.keyIds = new HashSet<String>();
    }

    @Override
    public void handleQueryResult(String keyId, List<Proposition> propositions, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references) throws QueryResultsHandlerProcessingException {
        try {
            if (this.criteria == null || this.criteria.evaluate(propositions)) {
                ++this.i;
                if (this.i % this.batchSize == 0) {
                    this.dataSource.writeKeys(this.keyIds);
                    this.keyIds = new HashSet<String>();
                } else {
                    this.keyIds.add(keyId);
                }
            }
        }
        catch (DataSourceWriteException | CriteriaEvaluateException ex) {
            throw new QueryResultsHandlerProcessingException("Error processing query results", ex);
        }
    }

    @Override
    public void finish() throws QueryResultsHandlerProcessingException {
        if (!this.keyIds.isEmpty()) {
            try {
                this.dataSource.writeKeys(this.keyIds);
            }
            catch (DataSourceWriteException ex) {
                throw new QueryResultsHandlerProcessingException(ex);
            }
        }
    }
}

