/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.KnowledgeSourceCache;
import org.protempa.dest.table.Link;
import org.protempa.dest.table.Util;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;

public class LinkTraverser {
    private final Set<Proposition> cache = new HashSet<Proposition>();

    public List<Proposition> traverseLinks(Link[] links, Proposition proposition, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references, KnowledgeSourceCache ksCache) {
        LinkedList<Proposition> result = new LinkedList<Proposition>();
        Logger logger = Util.logger();
        result.add(proposition);
        if (links != null) {
            int num = 1;
            for (Link link : links) {
                for (int j = 0; j < num; ++j) {
                    Proposition prop = result.remove();
                    Collection<Proposition> c = link.traverse(prop, forwardDerivations, backwardDerivations, references, ksCache, this.cache);
                    result.addAll(c);
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "{0} traversed to {1} with {2}", new Object[]{this.getClass().getName(), result, link});
                }
                num = result.size();
                this.cache.clear();
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "{0} traversed to {1}", new Object[]{this.getClass().getName(), result});
        }
        return result;
    }
}

