/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.table;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;

public final class PropertyConstraint {
    private final String propertyName;
    private final ValueComparator valueComparator;
    private final Value value;

    public PropertyConstraint(String propertyName, ValueComparator valueComparator, Value value) {
        if (propertyName == null) {
            throw new IllegalArgumentException("propertyName cannot be null");
        }
        if (valueComparator == null) {
            throw new IllegalArgumentException("valueComparator cannot be null");
        }
        this.propertyName = propertyName;
        this.valueComparator = valueComparator;
        this.value = value;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Value getValue() {
        return this.value;
    }

    public ValueComparator getValueComparator() {
        return this.valueComparator;
    }

    String getFormatted() {
        StringBuilder str = new StringBuilder();
        str.append(this.propertyName);
        str.append(this.valueComparator.getComparatorString());
        if (this.value != null) {
            str.append(this.value.getFormatted());
        } else {
            str.append("null");
        }
        return str.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.valueComparator == null ? 0 : this.valueComparator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyConstraint other = (PropertyConstraint)obj;
        if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.valueComparator == other.valueComparator;
    }
}

